package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.ReleaseDateStatus

/**
 *  Fields of the [ReleaseDateStatus] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#release-date-status](https://api-docs.igdb.com/#release-date-status)
 */
public enum class ReleaseDateStatusField(
  public override val igdbName: String,
) : IgdbField<ReleaseDateStatus> {
  /**
   *  Field "id" of the [ReleaseDateStatus] IGDB entity. Matches [ReleaseDateStatus.id].
   */
  ID("id"),
  /**
   *  Field "name" of the [ReleaseDateStatus] IGDB entity. Matches [ReleaseDateStatus.name].
   */
  NAME("name"),
  /**
   *  Field "description" of the [ReleaseDateStatus] IGDB entity. Matches
   * [ReleaseDateStatus.description].
   */
  DESCRIPTION("description"),
  /**
   *  Field "created_at" of the [ReleaseDateStatus] IGDB entity. Matches
   * [ReleaseDateStatus.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "updated_at" of the [ReleaseDateStatus] IGDB entity. Matches
   * [ReleaseDateStatus.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "checksum" of the [ReleaseDateStatus] IGDB entity. Matches [ReleaseDateStatus.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
