package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.TestDummy

/**
 *  Fields of the [TestDummy] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#test-dummy](https://api-docs.igdb.com/#test-dummy)
 */
public enum class TestDummyField(
  public override val igdbName: String,
) : IgdbField<TestDummy> {
  /**
   *  Field "id" of the [TestDummy] IGDB entity. Matches [TestDummy.id].
   */
  ID("id"),
  /**
   *  Field "bool_value" of the [TestDummy] IGDB entity. Matches [TestDummy.bool_value].
   */
  BOOL_VALUE("bool_value"),
  /**
   *  Field "created_at" of the [TestDummy] IGDB entity. Matches [TestDummy.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "enum_test" of the [TestDummy] IGDB entity. Matches [TestDummy.enum_test].
   */
  ENUM_TEST("enum_test"),
  /**
   *  Field "float_value" of the [TestDummy] IGDB entity. Matches [TestDummy.float_value].
   */
  FLOAT_VALUE("float_value"),
  /**
   *  Field "game" of the [TestDummy] IGDB entity. Matches [TestDummy.game].
   */
  GAME("game"),
  /**
   *  Field "integer_array" of the [TestDummy] IGDB entity. Matches [TestDummy.integer_array].
   */
  INTEGER_ARRAY("integer_array"),
  /**
   *  Field "integer_value" of the [TestDummy] IGDB entity. Matches [TestDummy.integer_value].
   */
  INTEGER_VALUE("integer_value"),
  /**
   *  Field "name" of the [TestDummy] IGDB entity. Matches [TestDummy.name].
   */
  NAME("name"),
  /**
   *  Field "new_integer_value" of the [TestDummy] IGDB entity. Matches
   * [TestDummy.new_integer_value].
   */
  NEW_INTEGER_VALUE("new_integer_value"),
  /**
   *  Field "private" of the [TestDummy] IGDB entity. Matches [TestDummy.`private`].
   */
  PRIVATE("private"),
  /**
   *  Field "slug" of the [TestDummy] IGDB entity. Matches [TestDummy.slug].
   */
  SLUG("slug"),
  /**
   *  Field "string_array" of the [TestDummy] IGDB entity. Matches [TestDummy.string_array].
   */
  STRING_ARRAY("string_array"),
  /**
   *  Field "test_dummies" of the [TestDummy] IGDB entity. Matches [TestDummy.test_dummies].
   */
  TEST_DUMMIES("test_dummies"),
  /**
   *  Field "test_dummy" of the [TestDummy] IGDB entity. Matches [TestDummy.test_dummy].
   */
  TEST_DUMMY("test_dummy"),
  /**
   *  Field "updated_at" of the [TestDummy] IGDB entity. Matches [TestDummy.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [TestDummy] IGDB entity. Matches [TestDummy.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [TestDummy] IGDB entity. Matches [TestDummy.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
