package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Website

/**
 *  Fields of the [Website] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#website](https://api-docs.igdb.com/#website)
 */
public enum class WebsiteField(
  public override val igdbName: String,
) : IgdbField<Website> {
  /**
   *  Field "id" of the [Website] IGDB entity. Matches [Website.id].
   */
  ID("id"),
  /**
   *  Field "category" of the [Website] IGDB entity. Matches [Website.category].
   */
  CATEGORY("category"),
  /**
   *  Field "game" of the [Website] IGDB entity. Matches [Website.game].
   */
  GAME("game"),
  /**
   *  Field "trusted" of the [Website] IGDB entity. Matches [Website.trusted].
   */
  TRUSTED("trusted"),
  /**
   *  Field "url" of the [Website] IGDB entity. Matches [Website.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [Website] IGDB entity. Matches [Website.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
