package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Genre
import ru.pixnews.igdbclient.scheme.`field`.GenreField

private val _genreFieldDslInstance: GenreFieldDsl = GenreFieldDsl()

public val Genre.Companion.`field`: GenreFieldDsl
  get() = _genreFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Genre] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#genre](https://api-docs.igdb.com/#genre)
 */
@IgdbClientDsl
public class GenreFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<GenreField, Genre>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Genre] Igdb entity.
   *
   *  The value will be returned in the [Genre.id] field of the response
   */
  public val id: IgdbRequestField<Genre>
    get() = fieldWithId(GenreField.ID)

  /**
   *  Query for the "created_at" field of the [Genre] Igdb entity.
   *
   *  The value will be returned in the [Genre.created_at] field of the response
   */
  public val created_at: IgdbRequestField<Genre>
    get() = fieldWithId(GenreField.CREATED_AT)

  /**
   *  Query for the "name" field of the [Genre] Igdb entity.
   *
   *  The value will be returned in the [Genre.name] field of the response
   */
  public val name: IgdbRequestField<Genre>
    get() = fieldWithId(GenreField.NAME)

  /**
   *  Query for the "slug" field of the [Genre] Igdb entity.
   *
   *  The value will be returned in the [Genre.slug] field of the response
   */
  public val slug: IgdbRequestField<Genre>
    get() = fieldWithId(GenreField.SLUG)

  /**
   *  Query for the "updated_at" field of the [Genre] Igdb entity.
   *
   *  The value will be returned in the [Genre.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<Genre>
    get() = fieldWithId(GenreField.UPDATED_AT)

  /**
   *  Query for the "url" field of the [Genre] Igdb entity.
   *
   *  The value will be returned in the [Genre.url] field of the response
   */
  public val url: IgdbRequestField<Genre>
    get() = fieldWithId(GenreField.URL)

  /**
   *  Query for the "checksum" field of the [Genre] Igdb entity.
   *
   *  The value will be returned in the [Genre.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Genre>
    get() = fieldWithId(GenreField.CHECKSUM)
}
