package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.AgeRatingContentDescription

/**
 *  Fields of the [AgeRatingContentDescription] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#age-rating-content-description](https://api-docs.igdb.com/#age-rating-content-description)
 */
public enum class AgeRatingContentDescriptionField(
  public override val igdbName: String,
) : IgdbField<AgeRatingContentDescription> {
  /**
   *  Field "id" of the [AgeRatingContentDescription] IGDB entity. Matches
   * [AgeRatingContentDescription.id].
   */
  ID("id"),
  /**
   *  Field "category" of the [AgeRatingContentDescription] IGDB entity. Matches
   * [AgeRatingContentDescription.category].
   */
  CATEGORY("category"),
  /**
   *  Field "description" of the [AgeRatingContentDescription] IGDB entity. Matches
   * [AgeRatingContentDescription.description].
   */
  DESCRIPTION("description"),
  /**
   *  Field "checksum" of the [AgeRatingContentDescription] IGDB entity. Matches
   * [AgeRatingContentDescription.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
