package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Company

/**
 *  Fields of the [Company] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#company](https://api-docs.igdb.com/#company)
 */
public enum class CompanyField(
  public override val igdbName: String,
) : IgdbField<Company> {
  /**
   *  Field "id" of the [Company] IGDB entity. Matches [Company.id].
   */
  ID("id"),
  /**
   *  Field "change_date" of the [Company] IGDB entity. Matches [Company.change_date].
   */
  CHANGE_DATE("change_date"),
  /**
   *  Field "change_date_category" of the [Company] IGDB entity. Matches
   * [Company.change_date_category].
   */
  CHANGE_DATE_CATEGORY("change_date_category"),
  /**
   *  Field "changed_company_id" of the [Company] IGDB entity. Matches [Company.changed_company_id].
   */
  CHANGED_COMPANY_ID("changed_company_id"),
  /**
   *  Field "country" of the [Company] IGDB entity. Matches [Company.country].
   */
  COUNTRY("country"),
  /**
   *  Field "created_at" of the [Company] IGDB entity. Matches [Company.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "description" of the [Company] IGDB entity. Matches [Company.description].
   */
  DESCRIPTION("description"),
  /**
   *  Field "developed" of the [Company] IGDB entity. Matches [Company.developed].
   */
  DEVELOPED("developed"),
  /**
   *  Field "logo" of the [Company] IGDB entity. Matches [Company.logo].
   */
  LOGO("logo"),
  /**
   *  Field "name" of the [Company] IGDB entity. Matches [Company.name].
   */
  NAME("name"),
  /**
   *  Field "parent" of the [Company] IGDB entity. Matches [Company.parent].
   */
  PARENT("parent"),
  /**
   *  Field "published" of the [Company] IGDB entity. Matches [Company.published].
   */
  PUBLISHED("published"),
  /**
   *  Field "slug" of the [Company] IGDB entity. Matches [Company.slug].
   */
  SLUG("slug"),
  /**
   *  Field "start_date" of the [Company] IGDB entity. Matches [Company.start_date].
   */
  START_DATE("start_date"),
  /**
   *  Field "start_date_category" of the [Company] IGDB entity. Matches
   * [Company.start_date_category].
   */
  START_DATE_CATEGORY("start_date_category"),
  /**
   *  Field "updated_at" of the [Company] IGDB entity. Matches [Company.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [Company] IGDB entity. Matches [Company.url].
   */
  URL("url"),
  /**
   *  Field "websites" of the [Company] IGDB entity. Matches [Company.websites].
   */
  WEBSITES("websites"),
  /**
   *  Field "checksum" of the [Company] IGDB entity. Matches [Company.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
