package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.ExternalGame

/**
 *  Fields of the [ExternalGame] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#external-game](https://api-docs.igdb.com/#external-game)
 */
public enum class ExternalGameField(
  public override val igdbName: String,
) : IgdbField<ExternalGame> {
  /**
   *  Field "id" of the [ExternalGame] IGDB entity. Matches [ExternalGame.id].
   */
  ID("id"),
  /**
   *  Field "category" of the [ExternalGame] IGDB entity. Matches [ExternalGame.category].
   */
  CATEGORY("category"),
  /**
   *  Field "created_at" of the [ExternalGame] IGDB entity. Matches [ExternalGame.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "game" of the [ExternalGame] IGDB entity. Matches [ExternalGame.game].
   */
  GAME("game"),
  /**
   *  Field "name" of the [ExternalGame] IGDB entity. Matches [ExternalGame.name].
   */
  NAME("name"),
  /**
   *  Field "uid" of the [ExternalGame] IGDB entity. Matches [ExternalGame.uid].
   */
  UID("uid"),
  /**
   *  Field "updated_at" of the [ExternalGame] IGDB entity. Matches [ExternalGame.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [ExternalGame] IGDB entity. Matches [ExternalGame.url].
   */
  URL("url"),
  /**
   *  Field "year" of the [ExternalGame] IGDB entity. Matches [ExternalGame.year].
   */
  YEAR("year"),
  /**
   *  Field "media" of the [ExternalGame] IGDB entity. Matches [ExternalGame.media].
   */
  MEDIA("media"),
  /**
   *  Field "platform" of the [ExternalGame] IGDB entity. Matches [ExternalGame.platform].
   */
  PLATFORM("platform"),
  /**
   *  Field "countries" of the [ExternalGame] IGDB entity. Matches [ExternalGame.countries].
   */
  COUNTRIES("countries"),
  /**
   *  Field "checksum" of the [ExternalGame] IGDB entity. Matches [ExternalGame.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
