package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.PlatformWebsite

/**
 *  Fields of the [PlatformWebsite] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#platform-website](https://api-docs.igdb.com/#platform-website)
 */
public enum class PlatformWebsiteField(
  public override val igdbName: String,
) : IgdbField<PlatformWebsite> {
  /**
   *  Field "id" of the [PlatformWebsite] IGDB entity. Matches [PlatformWebsite.id].
   */
  ID("id"),
  /**
   *  Field "category" of the [PlatformWebsite] IGDB entity. Matches [PlatformWebsite.category].
   */
  CATEGORY("category"),
  /**
   *  Field "trusted" of the [PlatformWebsite] IGDB entity. Matches [PlatformWebsite.trusted].
   */
  TRUSTED("trusted"),
  /**
   *  Field "url" of the [PlatformWebsite] IGDB entity. Matches [PlatformWebsite.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [PlatformWebsite] IGDB entity. Matches [PlatformWebsite.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
