package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Search

/**
 *  Fields of the [Search] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#search](https://api-docs.igdb.com/#search)
 */
public enum class SearchField(
  public override val igdbName: String,
) : IgdbField<Search> {
  /**
   *  Field "id" of the [Search] IGDB entity. Matches [Search.id].
   */
  ID("id"),
  /**
   *  Field "alternative_name" of the [Search] IGDB entity. Matches [Search.alternative_name].
   */
  ALTERNATIVE_NAME("alternative_name"),
  /**
   *  Field "character" of the [Search] IGDB entity. Matches [Search.character].
   */
  CHARACTER("character"),
  /**
   *  Field "collection" of the [Search] IGDB entity. Matches [Search.collection].
   */
  COLLECTION("collection"),
  /**
   *  Field "company" of the [Search] IGDB entity. Matches [Search.company].
   */
  COMPANY("company"),
  /**
   *  Field "description" of the [Search] IGDB entity. Matches [Search.description].
   */
  DESCRIPTION("description"),
  /**
   *  Field "game" of the [Search] IGDB entity. Matches [Search.game].
   */
  GAME("game"),
  /**
   *  Field "name" of the [Search] IGDB entity. Matches [Search.name].
   */
  NAME("name"),
  /**
   *  Field "platform" of the [Search] IGDB entity. Matches [Search.platform].
   */
  PLATFORM("platform"),
  /**
   *  Field "published_at" of the [Search] IGDB entity. Matches [Search.published_at].
   */
  PUBLISHED_AT("published_at"),
  /**
   *  Field "test_dummy" of the [Search] IGDB entity. Matches [Search.test_dummy].
   */
  TEST_DUMMY("test_dummy"),
  /**
   *  Field "theme" of the [Search] IGDB entity. Matches [Search.theme].
   */
  THEME("theme"),
  /**
   *  Field "checksum" of the [Search] IGDB entity. Matches [Search.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
