package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.AgeRatingContentDescription
import ru.pixnews.igdbclient.scheme.`field`.AgeRatingContentDescriptionField

private val _ageRatingContentDescriptionFieldDslInstance: AgeRatingContentDescriptionFieldDsl =
    AgeRatingContentDescriptionFieldDsl()

public val AgeRatingContentDescription.Companion.`field`: AgeRatingContentDescriptionFieldDsl
  get() = _ageRatingContentDescriptionFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [AgeRatingContentDescription] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#age-rating-content-description](https://api-docs.igdb.com/#age-rating-content-description)
 */
@IgdbClientDsl
public class AgeRatingContentDescriptionFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) :
    IgdbRequestFieldDsl<AgeRatingContentDescriptionField, AgeRatingContentDescription>(parentIgdbField)
    {
  /**
   *  Query for the "id" field of the [AgeRatingContentDescription] Igdb entity.
   *
   *  The value will be returned in the [AgeRatingContentDescription.id] field of the response
   */
  public val id: IgdbRequestField<AgeRatingContentDescription>
    get() = fieldWithId(AgeRatingContentDescriptionField.ID)

  /**
   *  Query for the "category" field of the [AgeRatingContentDescription] Igdb entity.
   *
   *  The value will be returned in the [AgeRatingContentDescription.category] field of the response
   */
  public val category: IgdbRequestField<AgeRatingContentDescription>
    get() = fieldWithId(AgeRatingContentDescriptionField.CATEGORY)

  /**
   *  Query for the "description" field of the [AgeRatingContentDescription] Igdb entity.
   *
   *  The value will be returned in the [AgeRatingContentDescription.description] field of the
   * response
   */
  public val description: IgdbRequestField<AgeRatingContentDescription>
    get() = fieldWithId(AgeRatingContentDescriptionField.DESCRIPTION)

  /**
   *  Query for the "checksum" field of the [AgeRatingContentDescription] Igdb entity.
   *
   *  The value will be returned in the [AgeRatingContentDescription.checksum] field of the response
   */
  public val checksum: IgdbRequestField<AgeRatingContentDescription>
    get() = fieldWithId(AgeRatingContentDescriptionField.CHECKSUM)
}
