package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.CollectionRelation
import ru.pixnews.igdbclient.scheme.`field`.CollectionRelationField

private val _collectionRelationFieldDslInstance: CollectionRelationFieldDsl =
    CollectionRelationFieldDsl()

public val CollectionRelation.Companion.`field`: CollectionRelationFieldDsl
  get() = _collectionRelationFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [CollectionRelation] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#collection-relation](https://api-docs.igdb.com/#collection-relation)
 */
@IgdbClientDsl
public class CollectionRelationFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<CollectionRelationField, CollectionRelation>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [CollectionRelation] Igdb entity.
   *
   *  The value will be returned in the [CollectionRelation.id] field of the response
   */
  public val id: IgdbRequestField<CollectionRelation>
    get() = fieldWithId(CollectionRelationField.ID)

  /**
   *  Fields of the "child_collection" ([Collection][ru.pixnews.igdbclient.model.Collection]) nested
   * IGDB entity
   */
  public val child_collection: CollectionFieldDsl
    get() = CollectionFieldDsl(fieldWithId(CollectionRelationField.CHILD_COLLECTION))

  /**
   *  Fields of the "parent_collection" ([Collection][ru.pixnews.igdbclient.model.Collection])
   * nested IGDB entity
   */
  public val parent_collection: CollectionFieldDsl
    get() = CollectionFieldDsl(fieldWithId(CollectionRelationField.PARENT_COLLECTION))

  /**
   *  Fields of the "type"
   * ([CollectionRelationType][ru.pixnews.igdbclient.model.CollectionRelationType]) nested IGDB entity
   */
  public val type: CollectionRelationTypeFieldDsl
    get() = CollectionRelationTypeFieldDsl(fieldWithId(CollectionRelationField.TYPE))

  /**
   *  Query for the "updated_at" field of the [CollectionRelation] Igdb entity.
   *
   *  The value will be returned in the [CollectionRelation.updated_at] field of the response
   */
  public val updated_at: IgdbRequestField<CollectionRelation>
    get() = fieldWithId(CollectionRelationField.UPDATED_AT)

  /**
   *  Query for the "created_at" field of the [CollectionRelation] Igdb entity.
   *
   *  The value will be returned in the [CollectionRelation.created_at] field of the response
   */
  public val created_at: IgdbRequestField<CollectionRelation>
    get() = fieldWithId(CollectionRelationField.CREATED_AT)

  /**
   *  Query for the "checksum" field of the [CollectionRelation] Igdb entity.
   *
   *  The value will be returned in the [CollectionRelation.checksum] field of the response
   */
  public val checksum: IgdbRequestField<CollectionRelation>
    get() = fieldWithId(CollectionRelationField.CHECKSUM)
}
