package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.MultiplayerMode
import ru.pixnews.igdbclient.scheme.`field`.MultiplayerModeField

private val _multiplayerModeFieldDslInstance: MultiplayerModeFieldDsl = MultiplayerModeFieldDsl()

public val MultiplayerMode.Companion.`field`: MultiplayerModeFieldDsl
  get() = _multiplayerModeFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [MultiplayerMode] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#multiplayer-mode](https://api-docs.igdb.com/#multiplayer-mode)
 */
@IgdbClientDsl
public class MultiplayerModeFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<MultiplayerModeField, MultiplayerMode>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [MultiplayerMode] Igdb entity.
   *
   *  The value will be returned in the [MultiplayerMode.id] field of the response
   */
  public val id: IgdbRequestField<MultiplayerMode>
    get() = fieldWithId(MultiplayerModeField.ID)

  /**
   *  Query for the "campaigncoop" field of the [MultiplayerMode] Igdb entity.
   *
   *  The value will be returned in the [MultiplayerMode.campaigncoop] field of the response
   */
  public val campaigncoop: IgdbRequestField<MultiplayerMode>
    get() = fieldWithId(MultiplayerModeField.CAMPAIGNCOOP)

  /**
   *  Query for the "dropin" field of the [MultiplayerMode] Igdb entity.
   *
   *  The value will be returned in the [MultiplayerMode.dropin] field of the response
   */
  public val dropin: IgdbRequestField<MultiplayerMode>
    get() = fieldWithId(MultiplayerModeField.DROPIN)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(MultiplayerModeField.GAME))

  /**
   *  Query for the "lancoop" field of the [MultiplayerMode] Igdb entity.
   *
   *  The value will be returned in the [MultiplayerMode.lancoop] field of the response
   */
  public val lancoop: IgdbRequestField<MultiplayerMode>
    get() = fieldWithId(MultiplayerModeField.LANCOOP)

  /**
   *  Query for the "offlinecoop" field of the [MultiplayerMode] Igdb entity.
   *
   *  The value will be returned in the [MultiplayerMode.offlinecoop] field of the response
   */
  public val offlinecoop: IgdbRequestField<MultiplayerMode>
    get() = fieldWithId(MultiplayerModeField.OFFLINECOOP)

  /**
   *  Query for the "offlinecoopmax" field of the [MultiplayerMode] Igdb entity.
   *
   *  The value will be returned in the [MultiplayerMode.offlinecoopmax] field of the response
   */
  public val offlinecoopmax: IgdbRequestField<MultiplayerMode>
    get() = fieldWithId(MultiplayerModeField.OFFLINECOOPMAX)

  /**
   *  Query for the "offlinemax" field of the [MultiplayerMode] Igdb entity.
   *
   *  The value will be returned in the [MultiplayerMode.offlinemax] field of the response
   */
  public val offlinemax: IgdbRequestField<MultiplayerMode>
    get() = fieldWithId(MultiplayerModeField.OFFLINEMAX)

  /**
   *  Query for the "onlinecoop" field of the [MultiplayerMode] Igdb entity.
   *
   *  The value will be returned in the [MultiplayerMode.onlinecoop] field of the response
   */
  public val onlinecoop: IgdbRequestField<MultiplayerMode>
    get() = fieldWithId(MultiplayerModeField.ONLINECOOP)

  /**
   *  Query for the "onlinecoopmax" field of the [MultiplayerMode] Igdb entity.
   *
   *  The value will be returned in the [MultiplayerMode.onlinecoopmax] field of the response
   */
  public val onlinecoopmax: IgdbRequestField<MultiplayerMode>
    get() = fieldWithId(MultiplayerModeField.ONLINECOOPMAX)

  /**
   *  Query for the "onlinemax" field of the [MultiplayerMode] Igdb entity.
   *
   *  The value will be returned in the [MultiplayerMode.onlinemax] field of the response
   */
  public val onlinemax: IgdbRequestField<MultiplayerMode>
    get() = fieldWithId(MultiplayerModeField.ONLINEMAX)

  /**
   *  Fields of the "platform" ([Platform][ru.pixnews.igdbclient.model.Platform]) nested IGDB entity
   */
  public val platform: PlatformFieldDsl
    get() = PlatformFieldDsl(fieldWithId(MultiplayerModeField.PLATFORM))

  /**
   *  Query for the "splitscreen" field of the [MultiplayerMode] Igdb entity.
   *
   *  The value will be returned in the [MultiplayerMode.splitscreen] field of the response
   */
  public val splitscreen: IgdbRequestField<MultiplayerMode>
    get() = fieldWithId(MultiplayerModeField.SPLITSCREEN)

  /**
   *  Query for the "splitscreenonline" field of the [MultiplayerMode] Igdb entity.
   *
   *  The value will be returned in the [MultiplayerMode.splitscreenonline] field of the response
   */
  public val splitscreenonline: IgdbRequestField<MultiplayerMode>
    get() = fieldWithId(MultiplayerModeField.SPLITSCREENONLINE)

  /**
   *  Query for the "checksum" field of the [MultiplayerMode] Igdb entity.
   *
   *  The value will be returned in the [MultiplayerMode.checksum] field of the response
   */
  public val checksum: IgdbRequestField<MultiplayerMode>
    get() = fieldWithId(MultiplayerModeField.CHECKSUM)
}
