package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.PlatformFamily
import ru.pixnews.igdbclient.scheme.`field`.PlatformFamilyField

private val _platformFamilyFieldDslInstance: PlatformFamilyFieldDsl = PlatformFamilyFieldDsl()

public val PlatformFamily.Companion.`field`: PlatformFamilyFieldDsl
  get() = _platformFamilyFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [PlatformFamily] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#platform-family](https://api-docs.igdb.com/#platform-family)
 */
@IgdbClientDsl
public class PlatformFamilyFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<PlatformFamilyField, PlatformFamily>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [PlatformFamily] Igdb entity.
   *
   *  The value will be returned in the [PlatformFamily.id] field of the response
   */
  public val id: IgdbRequestField<PlatformFamily>
    get() = fieldWithId(PlatformFamilyField.ID)

  /**
   *  Query for the "name" field of the [PlatformFamily] Igdb entity.
   *
   *  The value will be returned in the [PlatformFamily.name] field of the response
   */
  public val name: IgdbRequestField<PlatformFamily>
    get() = fieldWithId(PlatformFamilyField.NAME)

  /**
   *  Query for the "slug" field of the [PlatformFamily] Igdb entity.
   *
   *  The value will be returned in the [PlatformFamily.slug] field of the response
   */
  public val slug: IgdbRequestField<PlatformFamily>
    get() = fieldWithId(PlatformFamilyField.SLUG)

  /**
   *  Query for the "checksum" field of the [PlatformFamily] Igdb entity.
   *
   *  The value will be returned in the [PlatformFamily.checksum] field of the response
   */
  public val checksum: IgdbRequestField<PlatformFamily>
    get() = fieldWithId(PlatformFamilyField.CHECKSUM)
}
