package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.PlatformVersionReleaseDate
import ru.pixnews.igdbclient.scheme.`field`.PlatformVersionReleaseDateField

private val _platformVersionReleaseDateFieldDslInstance: PlatformVersionReleaseDateFieldDsl =
    PlatformVersionReleaseDateFieldDsl()

public val PlatformVersionReleaseDate.Companion.`field`: PlatformVersionReleaseDateFieldDsl
  get() = _platformVersionReleaseDateFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [PlatformVersionReleaseDate] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#platform-version-release-date](https://api-docs.igdb.com/#platform-version-release-date)
 */
@IgdbClientDsl
public class PlatformVersionReleaseDateFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) :
    IgdbRequestFieldDsl<PlatformVersionReleaseDateField, PlatformVersionReleaseDate>(parentIgdbField)
    {
  /**
   *  Query for the "id" field of the [PlatformVersionReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionReleaseDate.id] field of the response
   */
  public val id: IgdbRequestField<PlatformVersionReleaseDate>
    get() = fieldWithId(PlatformVersionReleaseDateField.ID)

  /**
   *  Query for the "category" field of the [PlatformVersionReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionReleaseDate.category] field of the response
   */
  public val category: IgdbRequestField<PlatformVersionReleaseDate>
    get() = fieldWithId(PlatformVersionReleaseDateField.CATEGORY)

  /**
   *  Query for the "created_at" field of the [PlatformVersionReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionReleaseDate.created_at] field of the
   * response
   */
  public val created_at: IgdbRequestField<PlatformVersionReleaseDate>
    get() = fieldWithId(PlatformVersionReleaseDateField.CREATED_AT)

  /**
   *  Query for the "date" field of the [PlatformVersionReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionReleaseDate.date] field of the response
   */
  public val date: IgdbRequestField<PlatformVersionReleaseDate>
    get() = fieldWithId(PlatformVersionReleaseDateField.DATE)

  /**
   *  Query for the "human" field of the [PlatformVersionReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionReleaseDate.human] field of the response
   */
  public val human: IgdbRequestField<PlatformVersionReleaseDate>
    get() = fieldWithId(PlatformVersionReleaseDateField.HUMAN)

  /**
   *  Query for the "m" field of the [PlatformVersionReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionReleaseDate.m] field of the response
   */
  public val m: IgdbRequestField<PlatformVersionReleaseDate>
    get() = fieldWithId(PlatformVersionReleaseDateField.M)

  /**
   *  Fields of the "platform_version"
   * ([PlatformVersion][ru.pixnews.igdbclient.model.PlatformVersion]) nested IGDB entity
   */
  public val platform_version: PlatformVersionFieldDsl
    get() = PlatformVersionFieldDsl(fieldWithId(PlatformVersionReleaseDateField.PLATFORM_VERSION))

  /**
   *  Query for the "region" field of the [PlatformVersionReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionReleaseDate.region] field of the response
   */
  public val region: IgdbRequestField<PlatformVersionReleaseDate>
    get() = fieldWithId(PlatformVersionReleaseDateField.REGION)

  /**
   *  Query for the "updated_at" field of the [PlatformVersionReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionReleaseDate.updated_at] field of the
   * response
   */
  public val updated_at: IgdbRequestField<PlatformVersionReleaseDate>
    get() = fieldWithId(PlatformVersionReleaseDateField.UPDATED_AT)

  /**
   *  Query for the "y" field of the [PlatformVersionReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionReleaseDate.y] field of the response
   */
  public val y: IgdbRequestField<PlatformVersionReleaseDate>
    get() = fieldWithId(PlatformVersionReleaseDateField.Y)

  /**
   *  Query for the "checksum" field of the [PlatformVersionReleaseDate] Igdb entity.
   *
   *  The value will be returned in the [PlatformVersionReleaseDate.checksum] field of the response
   */
  public val checksum: IgdbRequestField<PlatformVersionReleaseDate>
    get() = fieldWithId(PlatformVersionReleaseDateField.CHECKSUM)
}
