package ru.pixnews.igdbclient.dsl.`field`

import ru.pixnews.igdbclient.dsl.IgdbClientDsl
import ru.pixnews.igdbclient.model.Website
import ru.pixnews.igdbclient.scheme.`field`.WebsiteField

private val _websiteFieldDslInstance: WebsiteFieldDsl = WebsiteFieldDsl()

public val Website.Companion.`field`: WebsiteFieldDsl
  get() = _websiteFieldDslInstance

/**
 *  Dsl to generate a query string for a field of the [Website] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#website](https://api-docs.igdb.com/#website)
 */
@IgdbClientDsl
public class WebsiteFieldDsl internal constructor(
  parentIgdbField: IgdbRequestField<*>? = null,
) : IgdbRequestFieldDsl<WebsiteField, Website>(parentIgdbField) {
  /**
   *  Query for the "id" field of the [Website] Igdb entity.
   *
   *  The value will be returned in the [Website.id] field of the response
   */
  public val id: IgdbRequestField<Website>
    get() = fieldWithId(WebsiteField.ID)

  /**
   *  Query for the "category" field of the [Website] Igdb entity.
   *
   *  The value will be returned in the [Website.category] field of the response
   */
  public val category: IgdbRequestField<Website>
    get() = fieldWithId(WebsiteField.CATEGORY)

  /**
   *  Fields of the "game" ([Game][ru.pixnews.igdbclient.model.Game]) nested IGDB entity
   */
  public val game: GameFieldDsl
    get() = GameFieldDsl(fieldWithId(WebsiteField.GAME))

  /**
   *  Query for the "trusted" field of the [Website] Igdb entity.
   *
   *  The value will be returned in the [Website.trusted] field of the response
   */
  public val trusted: IgdbRequestField<Website>
    get() = fieldWithId(WebsiteField.TRUSTED)

  /**
   *  Query for the "url" field of the [Website] Igdb entity.
   *
   *  The value will be returned in the [Website.url] field of the response
   */
  public val url: IgdbRequestField<Website>
    get() = fieldWithId(WebsiteField.URL)

  /**
   *  Query for the "checksum" field of the [Website] Igdb entity.
   *
   *  The value will be returned in the [Website.checksum] field of the response
   */
  public val checksum: IgdbRequestField<Website>
    get() = fieldWithId(WebsiteField.CHECKSUM)
}
