package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.MultiplayerMode

/**
 *  Fields of the [MultiplayerMode] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#multiplayer-mode](https://api-docs.igdb.com/#multiplayer-mode)
 */
public enum class MultiplayerModeField(
  public override val igdbName: String,
) : IgdbField<MultiplayerMode> {
  /**
   *  Field "id" of the [MultiplayerMode] IGDB entity. Matches [MultiplayerMode.id].
   */
  ID("id"),
  /**
   *  Field "campaigncoop" of the [MultiplayerMode] IGDB entity. Matches
   * [MultiplayerMode.campaigncoop].
   */
  CAMPAIGNCOOP("campaigncoop"),
  /**
   *  Field "dropin" of the [MultiplayerMode] IGDB entity. Matches [MultiplayerMode.dropin].
   */
  DROPIN("dropin"),
  /**
   *  Field "game" of the [MultiplayerMode] IGDB entity. Matches [MultiplayerMode.game].
   */
  GAME("game"),
  /**
   *  Field "lancoop" of the [MultiplayerMode] IGDB entity. Matches [MultiplayerMode.lancoop].
   */
  LANCOOP("lancoop"),
  /**
   *  Field "offlinecoop" of the [MultiplayerMode] IGDB entity. Matches
   * [MultiplayerMode.offlinecoop].
   */
  OFFLINECOOP("offlinecoop"),
  /**
   *  Field "offlinecoopmax" of the [MultiplayerMode] IGDB entity. Matches
   * [MultiplayerMode.offlinecoopmax].
   */
  OFFLINECOOPMAX("offlinecoopmax"),
  /**
   *  Field "offlinemax" of the [MultiplayerMode] IGDB entity. Matches [MultiplayerMode.offlinemax].
   */
  OFFLINEMAX("offlinemax"),
  /**
   *  Field "onlinecoop" of the [MultiplayerMode] IGDB entity. Matches [MultiplayerMode.onlinecoop].
   */
  ONLINECOOP("onlinecoop"),
  /**
   *  Field "onlinecoopmax" of the [MultiplayerMode] IGDB entity. Matches
   * [MultiplayerMode.onlinecoopmax].
   */
  ONLINECOOPMAX("onlinecoopmax"),
  /**
   *  Field "onlinemax" of the [MultiplayerMode] IGDB entity. Matches [MultiplayerMode.onlinemax].
   */
  ONLINEMAX("onlinemax"),
  /**
   *  Field "platform" of the [MultiplayerMode] IGDB entity. Matches [MultiplayerMode.platform].
   */
  PLATFORM("platform"),
  /**
   *  Field "splitscreen" of the [MultiplayerMode] IGDB entity. Matches
   * [MultiplayerMode.splitscreen].
   */
  SPLITSCREEN("splitscreen"),
  /**
   *  Field "splitscreenonline" of the [MultiplayerMode] IGDB entity. Matches
   * [MultiplayerMode.splitscreenonline].
   */
  SPLITSCREENONLINE("splitscreenonline"),
  /**
   *  Field "checksum" of the [MultiplayerMode] IGDB entity. Matches [MultiplayerMode.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
