package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.PlatformVersionReleaseDate

/**
 *  Fields of the [PlatformVersionReleaseDate] IGDB entity.
 *
 *  See
 * [https://api-docs.igdb.com/#platform-version-release-date](https://api-docs.igdb.com/#platform-version-release-date)
 */
public enum class PlatformVersionReleaseDateField(
  public override val igdbName: String,
) : IgdbField<PlatformVersionReleaseDate> {
  /**
   *  Field "id" of the [PlatformVersionReleaseDate] IGDB entity. Matches
   * [PlatformVersionReleaseDate.id].
   */
  ID("id"),
  /**
   *  Field "category" of the [PlatformVersionReleaseDate] IGDB entity. Matches
   * [PlatformVersionReleaseDate.category].
   */
  CATEGORY("category"),
  /**
   *  Field "created_at" of the [PlatformVersionReleaseDate] IGDB entity. Matches
   * [PlatformVersionReleaseDate.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "date" of the [PlatformVersionReleaseDate] IGDB entity. Matches
   * [PlatformVersionReleaseDate.date].
   */
  DATE("date"),
  /**
   *  Field "human" of the [PlatformVersionReleaseDate] IGDB entity. Matches
   * [PlatformVersionReleaseDate.human].
   */
  HUMAN("human"),
  /**
   *  Field "m" of the [PlatformVersionReleaseDate] IGDB entity. Matches
   * [PlatformVersionReleaseDate.m].
   */
  M("m"),
  /**
   *  Field "platform_version" of the [PlatformVersionReleaseDate] IGDB entity. Matches
   * [PlatformVersionReleaseDate.platform_version].
   */
  PLATFORM_VERSION("platform_version"),
  /**
   *  Field "region" of the [PlatformVersionReleaseDate] IGDB entity. Matches
   * [PlatformVersionReleaseDate.region].
   */
  REGION("region"),
  /**
   *  Field "updated_at" of the [PlatformVersionReleaseDate] IGDB entity. Matches
   * [PlatformVersionReleaseDate.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "y" of the [PlatformVersionReleaseDate] IGDB entity. Matches
   * [PlatformVersionReleaseDate.y].
   */
  Y("y"),
  /**
   *  Field "checksum" of the [PlatformVersionReleaseDate] IGDB entity. Matches
   * [PlatformVersionReleaseDate.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
