package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Region

/**
 *  Fields of the [Region] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#region](https://api-docs.igdb.com/#region)
 */
public enum class RegionField(
  public override val igdbName: String,
) : IgdbField<Region> {
  /**
   *  Field "id" of the [Region] IGDB entity. Matches [Region.id].
   */
  ID("id"),
  /**
   *  Field "name" of the [Region] IGDB entity. Matches [Region.name].
   */
  NAME("name"),
  /**
   *  Field "category" of the [Region] IGDB entity. Matches [Region.category].
   */
  CATEGORY("category"),
  /**
   *  Field "identifier" of the [Region] IGDB entity. Matches [Region.identifier].
   */
  IDENTIFIER("identifier"),
  /**
   *  Field "created_at" of the [Region] IGDB entity. Matches [Region.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "updated_at" of the [Region] IGDB entity. Matches [Region.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "checksum" of the [Region] IGDB entity. Matches [Region.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
