package ru.pixnews.igdbclient.scheme.`field`

import kotlin.String
import ru.pixnews.igdbclient.model.Theme

/**
 *  Fields of the [Theme] IGDB entity.
 *
 *  See [https://api-docs.igdb.com/#theme](https://api-docs.igdb.com/#theme)
 */
public enum class ThemeField(
  public override val igdbName: String,
) : IgdbField<Theme> {
  /**
   *  Field "id" of the [Theme] IGDB entity. Matches [Theme.id].
   */
  ID("id"),
  /**
   *  Field "created_at" of the [Theme] IGDB entity. Matches [Theme.created_at].
   */
  CREATED_AT("created_at"),
  /**
   *  Field "name" of the [Theme] IGDB entity. Matches [Theme.name].
   */
  NAME("name"),
  /**
   *  Field "slug" of the [Theme] IGDB entity. Matches [Theme.slug].
   */
  SLUG("slug"),
  /**
   *  Field "updated_at" of the [Theme] IGDB entity. Matches [Theme.updated_at].
   */
  UPDATED_AT("updated_at"),
  /**
   *  Field "url" of the [Theme] IGDB entity. Matches [Theme.url].
   */
  URL("url"),
  /**
   *  Field "checksum" of the [Theme] IGDB entity. Matches [Theme.checksum].
   */
  CHECKSUM("checksum"),
  ;

  override fun toString(): String = igdbName
}
