/*
 * Decompiled with CFR 0.152.
 */
package ru.pixnews.igdbclient.okhttp;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.pixnews.igdbclient.internal.IgdbHttpClient;
import ru.pixnews.igdbclient.internal.RequestExecutor;
import ru.pixnews.igdbclient.internal.model.IgdbAuthToken;
import ru.pixnews.igdbclient.internal.model.IgdbClientConfig;
import ru.pixnews.igdbclient.internal.twitch.TwitchTokenFetcher;
import ru.pixnews.igdbclient.okhttp.OkhttpRequestExecutor;
import ru.pixnews.igdbclient.okhttp.OkhttpTwitchTokenFetcher;
import ru.pixnews.igdbclient.okhttp.dsl.IgdbOkhttpConfig;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lru/pixnews/igdbclient/okhttp/OkhttpIgdbHttpClientImplementation;", "Lru/pixnews/igdbclient/internal/IgdbHttpClient;", "config", "Lru/pixnews/igdbclient/internal/model/IgdbClientConfig;", "Lru/pixnews/igdbclient/okhttp/dsl/IgdbOkhttpConfig;", "(Lru/pixnews/igdbclient/internal/model/IgdbClientConfig;)V", "backgroundDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "baseUrl", "Lokhttp3/HttpUrl;", "callFactory", "Lokhttp3/Call$Factory;", "headers", "", "", "", "okhttpConfig", "requestExecutorFactory", "Lkotlin/Function1;", "Lru/pixnews/igdbclient/internal/model/IgdbAuthToken;", "Lru/pixnews/igdbclient/internal/RequestExecutor;", "getRequestExecutorFactory", "()Lkotlin/jvm/functions/Function1;", "twitchTokenFetcherFactory", "Lkotlin/Function0;", "Lru/pixnews/igdbclient/internal/twitch/TwitchTokenFetcher;", "getTwitchTokenFetcherFactory", "()Lkotlin/jvm/functions/Function0;", "userAgent", "igdbclient-okhttp"})
public final class OkhttpIgdbHttpClientImplementation
implements IgdbHttpClient {
    @NotNull
    private final IgdbOkhttpConfig okhttpConfig;
    @NotNull
    private final Call.Factory callFactory;
    @NotNull
    private final CoroutineDispatcher backgroundDispatcher;
    @Nullable
    private final String userAgent;
    @NotNull
    private final HttpUrl baseUrl;
    @NotNull
    private final Map<String, List<String>> headers;
    @NotNull
    private final Function1<IgdbAuthToken, RequestExecutor> requestExecutorFactory;
    @NotNull
    private final Function0<TwitchTokenFetcher> twitchTokenFetcherFactory;

    public OkhttpIgdbHttpClientImplementation(@NotNull IgdbClientConfig<IgdbOkhttpConfig> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        IgdbOkhttpConfig igdbOkhttpConfig = new IgdbOkhttpConfig();
        config.getHttpClientConfig().invoke((Object)igdbOkhttpConfig);
        this.okhttpConfig = igdbOkhttpConfig;
        Call.Factory factory = this.okhttpConfig.getCallFactory();
        if (factory == null) {
            factory = (Call.Factory)new OkHttpClient();
        }
        this.callFactory = factory;
        this.backgroundDispatcher = this.okhttpConfig.getBackgroundDispatcher();
        this.userAgent = config.getUserAgent();
        this.baseUrl = HttpUrl.Companion.get(config.getBaseUrl());
        this.headers = config.getHeaders();
        this.requestExecutorFactory = (Function1)new Function1<IgdbAuthToken, OkhttpRequestExecutor>(this){
            final /* synthetic */ OkhttpIgdbHttpClientImplementation this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final OkhttpRequestExecutor invoke(@Nullable IgdbAuthToken token) {
                return new OkhttpRequestExecutor(OkhttpIgdbHttpClientImplementation.access$getCallFactory$p(this.this$0), OkhttpIgdbHttpClientImplementation.access$getBaseUrl$p(this.this$0), token, OkhttpIgdbHttpClientImplementation.access$getUserAgent$p(this.this$0), OkhttpIgdbHttpClientImplementation.access$getHeaders$p(this.this$0), OkhttpIgdbHttpClientImplementation.access$getBackgroundDispatcher$p(this.this$0), null, 64, null);
            }
        };
        this.twitchTokenFetcherFactory = (Function0)new Function0<OkhttpTwitchTokenFetcher>(this){
            final /* synthetic */ OkhttpIgdbHttpClientImplementation this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OkhttpTwitchTokenFetcher invoke() {
                Call.Factory factory = OkhttpIgdbHttpClientImplementation.access$getCallFactory$p(this.this$0);
                CoroutineDispatcher coroutineDispatcher = OkhttpIgdbHttpClientImplementation.access$getBackgroundDispatcher$p(this.this$0);
                String string = OkhttpIgdbHttpClientImplementation.access$getUserAgent$p(this.this$0);
                return new OkhttpTwitchTokenFetcher(factory, null, string, coroutineDispatcher, null, null, null, 114, null);
            }
        };
    }

    @NotNull
    public Function1<IgdbAuthToken, RequestExecutor> getRequestExecutorFactory() {
        return this.requestExecutorFactory;
    }

    @NotNull
    public Function0<TwitchTokenFetcher> getTwitchTokenFetcherFactory() {
        return this.twitchTokenFetcherFactory;
    }

    public static final /* synthetic */ Call.Factory access$getCallFactory$p(OkhttpIgdbHttpClientImplementation $this) {
        return $this.callFactory;
    }

    public static final /* synthetic */ HttpUrl access$getBaseUrl$p(OkhttpIgdbHttpClientImplementation $this) {
        return $this.baseUrl;
    }

    public static final /* synthetic */ String access$getUserAgent$p(OkhttpIgdbHttpClientImplementation $this) {
        return $this.userAgent;
    }

    public static final /* synthetic */ Map access$getHeaders$p(OkhttpIgdbHttpClientImplementation $this) {
        return $this.headers;
    }

    public static final /* synthetic */ CoroutineDispatcher access$getBackgroundDispatcher$p(OkhttpIgdbHttpClientImplementation $this) {
        return $this.backgroundDispatcher;
    }
}

