/*
 * Decompiled with CFR 0.152.
 */
package ru.pixnews.igdbclient.okhttp;

import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.pixnews.igdbclient.IgdbResult;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00020\u0007H\u0002\u001aX\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\u0003\"\b\b\u0001\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u000b0\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00020\u0007H\u0002\u001a:\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020\u000f0\n\"\b\b\u0000\u0010\u000b*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u000b0\u0007H\u0002\u001ap\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\u0003\"\b\b\u0001\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00050\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u000b0\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00020\u0007H\u0080@\u00f8\u0001\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"parseErrorResponseBody", "Lru/pixnews/igdbclient/IgdbResult$Failure$HttpFailure;", "E", "", "response", "Lokhttp3/Response;", "httpErrorParser", "Lkotlin/Function1;", "Lokio/BufferedSource;", "parseHttpResponse", "Lru/pixnews/igdbclient/IgdbResult;", "T", "successResponseParser", "errorResponseParser", "parseSuccessResponseBody", "", "parser", "toIgdbResult", "Lkotlin/Result;", "backgroundDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Ljava/lang/Object;Lkotlinx/coroutines/CoroutineDispatcher;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "igdbclient-okhttp"})
@SourceDebugExtension(value={"SMAP\nOkhttpToIgdbResponseConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkhttpToIgdbResponseConverter.kt\nru/pixnews/igdbclient/okhttp/OkhttpToIgdbResponseConverterKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class OkhttpToIgdbResponseConverterKt {
    @Nullable
    public static final <T, E> Object toIgdbResult(@NotNull Object $this$toIgdbResult, @NotNull CoroutineDispatcher backgroundDispatcher, @NotNull Function1<? super BufferedSource, ? extends T> successResponseParser, @NotNull Function1<? super BufferedSource, ? extends E> errorResponseParser, @NotNull Continuation<? super IgdbResult<? extends T, ? extends E>> $completion) {
        IgdbResult igdbResult;
        Object object = $this$toIgdbResult;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            Response response = (Response)object;
            boolean bl = false;
            Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)backgroundDispatcher), (Function2)new Function2<CoroutineScope, Continuation<? super IgdbResult<? extends T, ? extends E>>, Object>(response, successResponseParser, errorResponseParser, null){
                int label;
                final /* synthetic */ Response $response;
                final /* synthetic */ Function1<BufferedSource, T> $successResponseParser;
                final /* synthetic */ Function1<BufferedSource, E> $errorResponseParser;
                {
                    this.$response = $response;
                    this.$successResponseParser = $successResponseParser;
                    this.$errorResponseParser = $errorResponseParser;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            return OkhttpToIgdbResponseConverterKt.access$parseHttpResponse(this.$response, this.$successResponseParser, this.$errorResponseParser);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super IgdbResult<? extends T, ? extends E>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, $completion);
            if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object2;
            }
            igdbResult = (IgdbResult)object2;
        } else {
            Throwable error = throwable;
            boolean bl = false;
            igdbResult = (IgdbResult)(error instanceof IOException ? (IgdbResult.Failure)new IgdbResult.Failure.NetworkFailure(error) : (IgdbResult.Failure)new IgdbResult.Failure.UnknownFailure(error));
        }
        return igdbResult;
    }

    public static /* synthetic */ Object toIgdbResult$default(Object object, CoroutineDispatcher coroutineDispatcher, Function1 function1, Function1 function12, Continuation continuation, int n, Object object2) {
        if ((n & 1) != 0) {
            coroutineDispatcher = Dispatchers.getDefault();
        }
        return OkhttpToIgdbResponseConverterKt.toIgdbResult(object, coroutineDispatcher, function1, function12, continuation);
    }

    private static final <T, E> IgdbResult<T, E> parseHttpResponse(Response response, Function1<? super BufferedSource, ? extends T> successResponseParser, Function1<? super BufferedSource, ? extends E> errorResponseParser) {
        IgdbResult igdbResult;
        int n = response.code();
        boolean bl = 200 <= n ? n < 300 : false;
        if (bl) {
            igdbResult = OkhttpToIgdbResponseConverterKt.parseSuccessResponseBody(response, successResponseParser);
        } else {
            boolean bl2 = 400 <= n ? n < 600 : false;
            if (bl2) {
                igdbResult = (IgdbResult)OkhttpToIgdbResponseConverterKt.parseErrorResponseBody(response, errorResponseParser);
            } else {
                Object object;
                Object object2;
                String string = response.message();
                int n2 = response.code();
                try {
                    boolean bl3 = false;
                    ResponseBody responseBody = response.body();
                    object2 = Result.constructor-impl((Object)((byte[])(responseBody != null ? responseBody.bytes() : null)));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object = object2;
                byte[] byArray = (byte[])(Result.isFailure-impl((Object)object2) ? null : object2);
                String string2 = string;
                int n3 = n2;
                igdbResult = (IgdbResult)new IgdbResult.Failure.UnknownHttpCodeFailure(n3, string2, byArray);
            }
        }
        return igdbResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> IgdbResult parseSuccessResponseBody(Response response, Function1<? super BufferedSource, ? extends T> parser) {
        IgdbResult igdbResult;
        try {
            Object object;
            ResponseBody responseBody = response.body();
            Intrinsics.checkNotNull((Object)responseBody);
            Closeable closeable = (Closeable)responseBody;
            Throwable throwable = null;
            try {
                Object object2;
                ResponseBody responseBody2 = (ResponseBody)closeable;
                boolean bl = false;
                Closeable closeable2 = (Closeable)responseBody2.source();
                Throwable throwable2 = null;
                try {
                    BufferedSource it = (BufferedSource)closeable2;
                    boolean bl2 = false;
                    object2 = parser.invoke((Object)it);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                object = object2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object result = object;
            igdbResult = (IgdbResult)new IgdbResult.Success(result);
        }
        catch (Throwable exception) {
            igdbResult = (IgdbResult)new IgdbResult.Failure.ApiFailure(exception);
        }
        return igdbResult;
    }

    private static final <E> IgdbResult.Failure.HttpFailure<E> parseErrorResponseBody(Response response, Function1<? super BufferedSource, ? extends E> httpErrorParser) {
        Object object;
        byte[] rawResponseBody;
        byte[] byArray;
        try {
            ResponseBody responseBody = response.body();
            byArray = (byte[])(responseBody != null ? responseBody.bytes() : null);
        }
        catch (Throwable ignore) {
            byArray = null;
        }
        if (rawResponseBody != null) {
            Object object2;
            byte[] rawResponse = rawResponseBody = byArray;
            boolean bl = false;
            try {
                object2 = httpErrorParser.invoke((Object)new Buffer().write(rawResponse));
            }
            catch (Exception exception) {
                object2 = null;
            }
            object = object2;
        } else {
            object = null;
        }
        Object errorMessage = object;
        return new IgdbResult.Failure.HttpFailure(response.code(), response.message(), errorMessage, CollectionsKt.toList((Iterable)((Iterable)response.headers())), errorMessage != null ? null : rawResponseBody);
    }

    public static final /* synthetic */ IgdbResult access$parseHttpResponse(Response response, Function1 successResponseParser, Function1 errorResponseParser) {
        return OkhttpToIgdbResponseConverterKt.parseHttpResponse(response, successResponseParser, errorResponseParser);
    }
}

