/*
 * Decompiled with CFR 0.152.
 */
package ru.primetalk.synapse.core;

import ru.primetalk.synapse.core.BasicSystemBuilder;
import ru.primetalk.synapse.core.Component;
import ru.primetalk.synapse.core.Contact;
import ru.primetalk.synapse.core.InnerSystemComponent;
import ru.primetalk.synapse.core.Link;
import ru.primetalk.synapse.core.LinkInfo;
import ru.primetalk.synapse.core.StateHandle;
import ru.primetalk.synapse.core.StateHandle$;
import ru.primetalk.synapse.core.StaticSystem;
import ru.primetalk.synapse.core.SystemBuilderExtension;
import ru.primetalk.synapse.core.SystemBuilderExtensionId;
import ru.primetalk.synapse.core.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class BasicSystemBuilder$class {
    public static void setSystemName(BasicSystemBuilder $this, String name) {
        $this.ru$primetalk$synapse$core$BasicSystemBuilder$$name_$eq(name);
    }

    public static String systemName(BasicSystemBuilder $this) {
        return $this.ru$primetalk$synapse$core$BasicSystemBuilder$$name();
    }

    public static void systemName_$eq(BasicSystemBuilder $this, String name) {
        $this.ru$primetalk$synapse$core$BasicSystemBuilder$$name_$eq(name);
    }

    public static StaticSystem toStaticSystem(BasicSystemBuilder $this) {
        List list = $this.components().toList();
        StaticSystem s = new StaticSystem((List)$this.inputContacts().toList().distinct(), (List)$this.outputContacts().toList().distinct(), $this.privateStateHandles().toList(), (List<Component>)$this.links().toList().reverse_$colon$colon$colon(list), $this.ru$primetalk$synapse$core$BasicSystemBuilder$$name(), $this.unhandledExceptionHandler());
        return (StaticSystem)$this.extensions().values().foldLeft((Object)s, (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final StaticSystem apply(StaticSystem s, SystemBuilderExtension e) {
                return e.postProcess(s);
            }
        });
    }

    public static void readOnly(BasicSystemBuilder $this) {
        $this.ru$primetalk$synapse$core$BasicSystemBuilder$$isReadOnly_$eq(true);
    }

    public static void assertWritable(BasicSystemBuilder $this) {
        if ($this.ru$primetalk$synapse$core$BasicSystemBuilder$$isReadOnly()) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The system builder '", "' is in read only mode."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.ru$primetalk$synapse$core$BasicSystemBuilder$$name()})));
        }
    }

    public static StaticSystem complete(BasicSystemBuilder $this) {
        $this.readOnly();
        return $this.toStaticSystem();
    }

    public static StateHandle state(BasicSystemBuilder $this, String name, Object initialValue) {
        $this.assertWritable();
        return $this.addStateHandle(StateHandle$.MODULE$.apply(name, initialValue));
    }

    public static void inputs(BasicSystemBuilder $this, Seq lc) {
        $this.inputContacts().$plus$plus$eq((TraversableOnce)lc);
    }

    public static void outputs(BasicSystemBuilder $this, Seq lc) {
        $this.assertWritable();
        lc.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicSystemBuilder $outer;

            public final Set<Contact<?>> apply(Contact<?> c) {
                if (this.$outer.links().exists((Function1)new Serializable(this, c){
                    public static final long serialVersionUID = 0L;
                    private final Contact c$1;

                    public final boolean apply(Link<?, ?, Nothing$, Object> link) {
                        Contact<?> contact = link.from();
                        Contact contact2 = this.c$1;
                        return !(contact != null ? !contact.equals(contact2) : contact2 != null);
                    }
                    {
                        this.c$1 = c$1;
                    }
                })) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The contact ", " cannot be added because there is a link such that link.from is this contact."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c})));
                }
                if (this.$outer.components().exists((Function1)new Serializable(this, c){
                    public static final long serialVersionUID = 0L;
                    private final Contact c$1;

                    public final boolean apply(Component component) {
                        return component.inputContacts().contains((Object)this.c$1);
                    }
                    {
                        this.c$1 = c$1;
                    }
                })) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The contact ", " cannot be added because there is a component such that component.inputContacts contains this contact."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c})));
                }
                return (Set)this.$outer.outputContacts().$plus$eq(c);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Contact input(BasicSystemBuilder $this, String name) {
        void var2_2;
        Contact c = package$.MODULE$.contact(name);
        $this.inputs((Seq<Contact<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Contact[]{c}));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Contact output(BasicSystemBuilder $this, String name) {
        void var2_2;
        Contact c = package$.MODULE$.contact(name);
        $this.outputs((Seq<Contact<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Contact[]{c}));
        return var2_2;
    }

    public static StateHandle addStateHandle(BasicSystemBuilder $this, StateHandle sh) {
        $this.assertWritable();
        return (StateHandle)$this.privateStateHandles().find((Function1)new Serializable($this, sh){
            public static final long serialVersionUID = 0L;
            private final StateHandle sh$1;

            public final boolean apply(StateHandle<?> sh0) {
                String string = sh0.name();
                String string2 = this.sh$1.name();
                return !(string != null ? !string.equals(string2) : string2 != null) && BoxesRunTime.equals(sh0.s0(), this.sh$1.s0());
            }
            {
                this.sh$1 = sh$1;
            }
        }).getOrElse((Function0)new Serializable($this, sh){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicSystemBuilder $outer;
            private final StateHandle sh$1;

            public final StateHandle<S> apply() {
                this.$outer.privateStateHandles().$plus$eq((Object)this.sh$1);
                return this.sh$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sh$1 = sh$1;
            }
        });
    }

    public static Contact addLink(BasicSystemBuilder $this, Contact from2, Contact to, String name, LinkInfo info) {
        Link link = new Link(from2, to, name, info);
        return $this.addLink(link);
    }

    public static Contact addLink(BasicSystemBuilder $this, Link link) {
        $this.assertWritable();
        if ($this.outputContacts().contains(link.from())) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The link ", " cannot be added because ", " is output contact."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{link, link.from().name()})));
        }
        $this.links().$plus$eq((Object)link);
        return link.to();
    }

    public static Component addComponent(BasicSystemBuilder $this, Component component) {
        $this.components().$plus$eq((Object)component);
        return component;
    }

    public static Object addSubsystem(BasicSystemBuilder $this, Object system, Seq sharedStateHandles, Function1 ev) {
        StaticSystem s = (StaticSystem)ev.apply(system);
        sharedStateHandles.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicSystemBuilder $outer;

            public final StateHandle<?> apply(StateHandle<?> x$2) {
                return this.$outer.addStateHandle(x$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Map s0withoutShared = (Map)s.s0().$minus$minus((GenTraversableOnce)sharedStateHandles);
        $this.components().$plus$eq((Object)new InnerSystemComponent(s, $this.state(new StringBuilder().append((Object)s.name()).append((Object)"State").toString(), s0withoutShared), sharedStateHandles.toList()));
        return system;
    }

    public static void addSubsystems(BasicSystemBuilder $this, Seq subsystems) {
        subsystems.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicSystemBuilder $outer;

            public final StaticSystem apply(StaticSystem subsystem) {
                return this.$outer.addSubsystem(subsystem, (Seq<StateHandle<?>>)Predef$.MODULE$.wrapRefArray((Object[])new StateHandle[0]), new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StaticSystem apply(StaticSystem x) {
                        return (StaticSystem)Predef$.MODULE$.identity((Object)x);
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static List successors(BasicSystemBuilder $this, Contact c) {
        List linkSuccessors = (List)((List)$this.links().toList().filter((Function1)new Serializable($this, c){
            public static final long serialVersionUID = 0L;
            private final Contact c$2;

            public final boolean apply(Link<?, ?, Nothing$, Object> x$3) {
                Contact<?> contact = x$3.from();
                Contact contact2 = this.c$2;
                return !(contact != null ? !contact.equals(contact2) : contact2 != null);
            }
            {
                this.c$2 = c$2;
            }
        })).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Contact<?> apply(Link<?, ?, Nothing$, Object> x$4) {
                return x$4.to();
            }
        }, List$.MODULE$.canBuildFrom());
        List compSuccessors = (List)((List)$this.components().toList().filter((Function1)new Serializable($this, c){
            public static final long serialVersionUID = 0L;
            private final Contact c$2;

            public final boolean apply(Component x$5) {
                return x$5.inputContacts().contains((Object)this.c$2);
            }
            {
                this.c$2 = c$2;
            }
        })).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<Contact<?>> apply(Component x$6) {
                return x$6.outputContacts();
            }
        }, List$.MODULE$.canBuildFrom());
        return (List)((SeqLike)linkSuccessors.$plus$plus((GenTraversableOnce)compSuccessors, List$.MODULE$.canBuildFrom())).distinct();
    }

    public static List predecessors(BasicSystemBuilder $this, Contact c) {
        List linkPredecessors = (List)((List)$this.links().toList().filter((Function1)new Serializable($this, c){
            public static final long serialVersionUID = 0L;
            private final Contact c$3;

            public final boolean apply(Link<?, ?, Nothing$, Object> x$7) {
                Contact<?> contact = x$7.to();
                Contact contact2 = this.c$3;
                return !(contact != null ? !contact.equals(contact2) : contact2 != null);
            }
            {
                this.c$3 = c$3;
            }
        })).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Contact<?> apply(Link<?, ?, Nothing$, Object> x$8) {
                return x$8.from();
            }
        }, List$.MODULE$.canBuildFrom());
        List compPredecessors = (List)((List)$this.components().toList().filter((Function1)new Serializable($this, c){
            public static final long serialVersionUID = 0L;
            private final Contact c$3;

            public final boolean apply(Component x$9) {
                return x$9.outputContacts().contains((Object)this.c$3);
            }
            {
                this.c$3 = c$3;
            }
        })).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<Contact<?>> apply(Component x$10) {
                return x$10.inputContacts();
            }
        }, List$.MODULE$.canBuildFrom());
        return (List)((SeqLike)linkPredecessors.$plus$plus((GenTraversableOnce)compPredecessors, List$.MODULE$.canBuildFrom())).distinct();
    }

    public static int minDistance(BasicSystemBuilder $this, Contact c1, Contact c2) {
        return BasicSystemBuilder$class.minDistance$1($this, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Contact[]{c1})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), BasicSystemBuilder$class.minDistance$default$3$1($this), c2);
    }

    public static SystemBuilderExtension extend(BasicSystemBuilder $this, SystemBuilderExtensionId extensionId) {
        return (SystemBuilderExtension)$this.extensions().getOrElseUpdate((Object)extensionId, (Function0)new Serializable($this, extensionId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BasicSystemBuilder $outer;
            private final SystemBuilderExtensionId extensionId$1;

            public final T apply() {
                return (T)((SystemBuilderExtension)this.extensionId$1.extend().apply((Object)this.$outer));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.extensionId$1 = extensionId$1;
            }
        });
    }

    public static void handleExceptions(BasicSystemBuilder $this, Function4 handler) {
        $this.unhandledExceptionHandler_$eq(handler);
    }

    public static Option findInput(BasicSystemBuilder $this, String name) {
        return $this.inputContacts().find((Function1)new Serializable($this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(Contact<?> x$11) {
                String string = x$11.name();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    public static Option findOutput(BasicSystemBuilder $this, String name) {
        return $this.outputContacts().find((Function1)new Serializable($this, name){
            public static final long serialVersionUID = 0L;
            private final String name$2;

            public final boolean apply(Contact<?> x$12) {
                String string = x$12.name();
                String string2 = this.name$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.name$2 = name$2;
            }
        });
    }

    private static final int minDistance$1(BasicSystemBuilder $this, scala.collection.immutable.Set toCheck, scala.collection.immutable.Set exclude, int dist, Contact c2$1) {
        while (true) {
            block5: {
                int n;
                block4: {
                    block3: {
                        if (!toCheck.isEmpty()) break block3;
                        n = -1;
                        break block4;
                    }
                    if (!toCheck.contains((Object)c2$1)) break block5;
                    n = dist;
                }
                return n;
            }
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)((Subtractable)toCheck.flatMap((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BasicSystemBuilder $outer;

                public final List<Contact<?>> apply(Contact<?> c) {
                    return this.$outer.successors(c);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)exclude);
            ++dist;
            exclude = (scala.collection.immutable.Set)exclude.$plus$plus((GenTraversableOnce)toCheck);
            toCheck = set;
        }
    }

    private static final int minDistance$default$3$1(BasicSystemBuilder $this) {
        return 0;
    }

    public static void $init$(BasicSystemBuilder $this) {
        $this.ru$primetalk$synapse$core$BasicSystemBuilder$$name_$eq($this.getClass().isAnonymousClass() ? "" : new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString($this.getClass().getSimpleName())).replaceAllLiterally("Builder", ""))).replaceAllLiterally("BuilderC", ""))).replaceAllLiterally("$", ""));
        $this.ru$primetalk$synapse$core$BasicSystemBuilder$_setter_$privateStateHandles_$eq((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.ru$primetalk$synapse$core$BasicSystemBuilder$_setter_$links_$eq((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.ru$primetalk$synapse$core$BasicSystemBuilder$_setter_$components_$eq((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.ru$primetalk$synapse$core$BasicSystemBuilder$_setter_$inputContacts_$eq((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.ru$primetalk$synapse$core$BasicSystemBuilder$_setter_$outputContacts_$eq((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.unhandledExceptionHandler_$eq(package$.MODULE$.defaultUnhandledExceptionHandler());
        $this.ru$primetalk$synapse$core$BasicSystemBuilder$_setter_$extensions_$eq((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.ru$primetalk$synapse$core$BasicSystemBuilder$$isReadOnly_$eq(false);
    }
}

