/*
 * Decompiled with CFR 0.152.
 */
package ru.sergkorot.dynamic.model.enums;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;
import ru.sergkorot.dynamic.operation.Operation;
import ru.sergkorot.dynamic.operation.OperationProvider;

public enum OperationType {
    IN("in", OperationProvider::in),
    NOT_IN("notIn", OperationProvider::notIn),
    LIKE("like", OperationProvider::like),
    EQUAL("eq", OperationProvider::eq),
    NOT_EQUAL("notEq", OperationProvider::notEq),
    IS_NULL("isNull", OperationProvider::isNull),
    LESS_THAN("lt", OperationProvider::lessThan),
    GREATER_THAN("gt", OperationProvider::greaterThan),
    LESS_THAN_OR_EQUALS("le", OperationProvider::lessThanOrEquals),
    GREATER_THAN_OR_EQUALS("ge", OperationProvider::greaterThanOrEquals),
    CONTAINS("contains", OperationProvider::contains);

    private final String operationName;
    private final Function<OperationProvider<?>, Operation<?>> linkToOperation;
    private static final Map<String, OperationType> operationMap;

    public static OperationType of(String typeName) {
        if (!StringUtils.hasText((String)typeName)) {
            return EQUAL;
        }
        return Optional.ofNullable(operationMap.get(typeName)).orElseThrow(() -> new IllegalArgumentException(String.format("operation %s not found", typeName)));
    }

    public <R> Operation<R> getOperation(OperationProvider<R> operationProvider) {
        return this.linkToOperation.apply(operationProvider);
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Function<OperationProvider<?>, Operation<?>> getLinkToOperation() {
        return this.linkToOperation;
    }

    private OperationType(String operationName, Function<OperationProvider<?>, Operation<?>> linkToOperation) {
        this.operationName = operationName;
        this.linkToOperation = linkToOperation;
    }

    static {
        operationMap = Stream.of(OperationType.values()).collect(Collectors.toUnmodifiableMap(OperationType::getOperationName, type -> type));
    }
}

