/*
 * Decompiled with CFR 0.152.
 */
package ru.sergkorot.dynamic.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import ru.sergkorot.dynamic.util.RegexpUtils;

public final class SortUtils {
    public static final int DEFAULT_OFFSET = 0;
    public static final int DEFAULT_LIMIT = 200;

    public static Sort makeSort(Collection<String> validNames, String sortValues) {
        return Sort.by(SortUtils.makeSortOrders(validNames, sortValues));
    }

    public static List<Sort.Order> makeSortOrders(Collection<String> validNames, String sortValues) {
        if (sortValues == null || sortValues.isBlank()) {
            return Collections.emptyList();
        }
        List<String> splitSortValues = RegexpUtils.transformToArrayFieldsNames(sortValues);
        return splitSortValues.stream().map(name -> SortUtils.checkName(validNames, name)).map(SortUtils::getOrder).collect(Collectors.toList());
    }

    private static Sort.Order getOrder(String name) {
        if (name.contains("-")) {
            return Sort.Order.desc((String)name.substring(1));
        }
        return Sort.Order.asc((String)name);
    }

    private static String checkName(Collection<String> validNames, String name) {
        if (!validNames.contains(SortUtils.getName(name))) {
            throw new IllegalArgumentException(String.format("Not found parameter with name: %s", name));
        }
        return name;
    }

    private static String getName(String name) {
        return name.startsWith("-") ? name.substring(1) : name;
    }

    private SortUtils() {
    }
}

