/*
 * Decompiled with CFR 0.152.
 */
package ru.sergkorot.dynamic.model.enums;

import java.time.DateTimeException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ValueType {
    STRING_VARIABLE((Class)String.class){

        @Override
        public <U> Boolean checkValueType(U u) {
            return u instanceof String && !ValueType.checkInstant(u);
        }

        @Override
        public Collection<?> castCollection(Object obj) {
            return Arrays.asList(obj.toString().split(","));
        }

        @Override
        public Object simpleCast(Object obj) {
            return obj;
        }
    }
    ,
    LONG_VARIABLE((Class)Long.class){

        @Override
        public <U> Boolean checkValueType(U u) {
            try {
                Long.parseLong(String.valueOf(u));
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        @Override
        public Collection<?> castCollection(Object obj) {
            return Arrays.asList(obj.toString().split(","));
        }

        @Override
        public Object simpleCast(Object obj) {
            return Long.parseLong(obj.toString());
        }
    }
    ,
    DOUBLE_VARIABLE((Class)Double.class){

        @Override
        public <U> Boolean checkValueType(U u) {
            try {
                double v = Double.parseDouble(String.valueOf(u));
                if (Double.isInfinite(v) || Double.isNaN(v)) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        @Override
        public Collection<?> castCollection(Object obj) {
            return Arrays.asList(obj.toString().split(","));
        }

        @Override
        public Object simpleCast(Object obj) {
            return Double.parseDouble(obj.toString());
        }
    }
    ,
    BOOLEAN_VARIABLE((Class)Boolean.class){

        @Override
        public <U> Boolean checkValueType(U u) {
            return BooleanUtils.toBooleanObject((String)String.valueOf(u)) != null;
        }

        @Override
        public Collection<?> castCollection(Object obj) {
            return Arrays.stream(obj.toString().split(",")).map(BooleanUtils::toBooleanObject).collect(Collectors.toList());
        }

        @Override
        public Object simpleCast(Object obj) {
            return BooleanUtils.toBooleanObject((String)obj.toString());
        }
    }
    ,
    DATETIME_VARIABLE((Class)Instant.class){

        @Override
        public <U> Boolean checkValueType(U u) {
            return u instanceof Instant || u instanceof String && ValueType.checkInstant(u);
        }

        @Override
        public Collection<?> castCollection(Object obj) {
            return Arrays.stream(obj.toString().split(",")).map(Instant::parse).collect(Collectors.toList());
        }

        @Override
        public Object simpleCast(Object obj) {
            return Instant.parse(obj.toString());
        }
    };

    private final Class<?> clazz;

    public abstract <U> Boolean checkValueType(U var1);

    public abstract Collection<?> castCollection(Object var1);

    public abstract Object simpleCast(Object var1);

    public static Object cast(Object value) {
        return Arrays.stream(ValueType.values()).filter(valueType -> valueType.checkValueType(value)).findFirst().map(valueType -> valueType.simpleCast(value)).orElseThrow();
    }

    public static Collection<?> collectionCast(Object value) {
        String firstElement = value.toString().split(",")[0];
        return Arrays.stream(ValueType.values()).filter(valueType -> valueType.checkValueType(firstElement)).findFirst().map(valueType -> valueType.castCollection(value)).orElseThrow();
    }

    private static boolean checkInstant(Object value) {
        try {
            Instant.parse((String)value);
        }
        catch (DateTimeException e) {
            return false;
        }
        return true;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    private ValueType(Class<?> clazz) {
        this.clazz = clazz;
    }
}

