/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import ru.tinkoff.acquiring.sdk.AcquiringApiException;
import ru.tinkoff.acquiring.sdk.CardStatus;
import ru.tinkoff.acquiring.sdk.CardStatusSerializer;
import ru.tinkoff.acquiring.sdk.CardsListDeserializer;
import ru.tinkoff.acquiring.sdk.Journal;
import ru.tinkoff.acquiring.sdk.NetworkException;
import ru.tinkoff.acquiring.sdk.PaymentStatus;
import ru.tinkoff.acquiring.sdk.PaymentStatusSerializer;
import ru.tinkoff.acquiring.sdk.requests.AcquiringRequest;
import ru.tinkoff.acquiring.sdk.requests.ChargeRequest;
import ru.tinkoff.acquiring.sdk.requests.FinishAuthorizeRequest;
import ru.tinkoff.acquiring.sdk.requests.GetCardListRequest;
import ru.tinkoff.acquiring.sdk.requests.GetStateRequest;
import ru.tinkoff.acquiring.sdk.requests.InitRequest;
import ru.tinkoff.acquiring.sdk.requests.RemoveCardRequest;
import ru.tinkoff.acquiring.sdk.responses.AcquiringResponse;
import ru.tinkoff.acquiring.sdk.responses.ChargeResponse;
import ru.tinkoff.acquiring.sdk.responses.FinishAuthorizeResponse;
import ru.tinkoff.acquiring.sdk.responses.GetCardListResponse;
import ru.tinkoff.acquiring.sdk.responses.GetStateResponse;
import ru.tinkoff.acquiring.sdk.responses.InitResponse;
import ru.tinkoff.acquiring.sdk.responses.RemoveCardResponse;

public class AcquiringApi {
    private static final String API_URL_RELEASE = "https://securepay.tinkoff.ru/rest";
    private static final String API_URL_DEBUG = "https://rest-api-test.tcsbank.ru/rest";
    private static final int STREAM_BUFFER_SIZE = 4096;
    public static final String API_REQUEST_METHOD = "POST";
    private final Gson gson = this.createGson();

    static String getUrl() {
        return Journal.isDebug() ? API_URL_DEBUG : API_URL_RELEASE;
    }

    AcquiringApi() {
    }

    InitResponse init(InitRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, InitResponse.class);
    }

    FinishAuthorizeResponse finishAuthorize(FinishAuthorizeRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, FinishAuthorizeResponse.class);
    }

    ChargeResponse charge(ChargeRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, ChargeResponse.class);
    }

    GetStateResponse getState(GetStateRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, GetStateResponse.class);
    }

    GetCardListResponse getCardList(GetCardListRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, GetCardListResponse.class);
    }

    RemoveCardResponse removeCard(RemoveCardRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, RemoveCardResponse.class);
    }

    private <R extends AcquiringResponse> R performRequest(AcquiringRequest request, Class<R> responseClass) throws NetworkException, AcquiringApiException {
        AcquiringResponse result;
        InputStreamReader responseReader = null;
        OutputStream requestContentStream = null;
        try {
            URL targetUrl = this.prepareURI(request.getApiMethod());
            String requestBody = this.encodeRequestBody(request.asMap());
            HttpURLConnection connection = (HttpURLConnection)targetUrl.openConnection();
            connection.setRequestMethod(API_REQUEST_METHOD);
            Journal.log(String.format("=== Sending %s request to %s", API_REQUEST_METHOD, targetUrl.toString()));
            if (!requestBody.isEmpty()) {
                Journal.log(String.format("===== Parameters: %s", requestBody));
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-length", String.valueOf(requestBody.length()));
                requestContentStream = connection.getOutputStream();
                requestContentStream.write(requestBody.getBytes());
            }
            responseReader = new InputStreamReader(connection.getInputStream());
            String response = this.read(responseReader);
            Journal.log(String.format("=== Got server response: %s", response));
            result = (AcquiringResponse)this.gson.fromJson(response, responseClass);
            this.closeQuietly(requestContentStream);
            this.closeQuietly(responseReader);
        }
        catch (IOException e) {
            try {
                throw new NetworkException("Unable to execute request " + request.getApiMethod(), e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(requestContentStream);
                this.closeQuietly(responseReader);
                throw throwable;
            }
        }
        if (!result.isSuccess()) {
            throw new AcquiringApiException(result);
        }
        return (R)result;
    }

    private URL prepareURI(String apiMethod) throws MalformedURLException {
        if (apiMethod == null || apiMethod.isEmpty()) {
            throw new IllegalArgumentException("Cannot prepare URL for request api method is empty or null!");
        }
        StringBuilder builder = new StringBuilder(AcquiringApi.getUrl());
        builder.append("/");
        builder.append(apiMethod);
        return new URL(builder.toString());
    }

    private String encodeRequestBody(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            try {
                String value = URLEncoder.encode(entry.getValue(), "UTF-8");
                builder.append(entry.getKey());
                builder.append('=');
                builder.append(value);
                builder.append('&');
            }
            catch (UnsupportedEncodingException e) {
                Journal.log(e);
            }
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    private Gson createGson() {
        return new GsonBuilder().registerTypeAdapter(CardStatus.class, (Object)new CardStatusSerializer()).registerTypeAdapter(PaymentStatus.class, (Object)new PaymentStatusSerializer()).registerTypeAdapter(GetCardListResponse.class, (Object)new CardsListDeserializer()).create();
    }

    private String read(InputStreamReader reader) throws IOException {
        int read;
        char[] buffer = new char[4096];
        StringBuilder result = new StringBuilder();
        while ((read = reader.read(buffer, 0, 4096)) != -1) {
            result.append(buffer, 0, read);
        }
        return result.toString();
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            Journal.log(e);
        }
    }
}

