/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.responses;

import com.google.gson.annotations.SerializedName;
import ru.tinkoff.acquiring.sdk.AcquiringSdkException;
import ru.tinkoff.acquiring.sdk.PaymentStatus;
import ru.tinkoff.acquiring.sdk.ThreeDsData;
import ru.tinkoff.acquiring.sdk.responses.AcquiringResponse;

public final class FinishAuthorizeResponse
extends AcquiringResponse {
    @SerializedName(value="PaymentId")
    private Long paymentId;
    @SerializedName(value="OrderId")
    private String orderId;
    @SerializedName(value="Amount")
    private Long amount;
    @SerializedName(value="ACSUrl")
    private String acsUrl;
    @SerializedName(value="MD")
    private String md;
    @SerializedName(value="PaReq")
    private String paReq;
    @SerializedName(value="Status")
    private PaymentStatus status;
    private transient ThreeDsData threeDsData;

    public ThreeDsData getThreeDsData() {
        if (this.threeDsData == null) {
            if (this.status == PaymentStatus.CONFIRMED) {
                this.threeDsData = ThreeDsData.EMPTY_THREE_DS_DATA;
            } else if (this.status == PaymentStatus.THREE_DS_CHECKING) {
                this.threeDsData = new ThreeDsData(this.paymentId, this.orderId, this.amount, this.acsUrl, this.md, this.paReq);
            } else {
                throw new AcquiringSdkException(new IllegalStateException("incorrect PaymentStatus " + (Object)((Object)this.status)));
            }
        }
        return this.threeDsData;
    }

    public Long getPaymentId() {
        return this.paymentId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public Long getAmount() {
        return this.amount;
    }

    public String getAcsUrl() {
        return this.acsUrl;
    }

    public String getMd() {
        return this.md;
    }

    public String getPaReq() {
        return this.paReq;
    }

    public PaymentStatus getStatus() {
        return this.status;
    }
}

