/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk;

import java.security.PublicKey;
import ru.tinkoff.acquiring.sdk.AcquiringApi;
import ru.tinkoff.acquiring.sdk.AcquiringApiException;
import ru.tinkoff.acquiring.sdk.AcquiringSdkException;
import ru.tinkoff.acquiring.sdk.Card;
import ru.tinkoff.acquiring.sdk.CardData;
import ru.tinkoff.acquiring.sdk.Journal;
import ru.tinkoff.acquiring.sdk.KeyCreator;
import ru.tinkoff.acquiring.sdk.Money;
import ru.tinkoff.acquiring.sdk.NetworkException;
import ru.tinkoff.acquiring.sdk.PaymentInfo;
import ru.tinkoff.acquiring.sdk.PaymentStatus;
import ru.tinkoff.acquiring.sdk.StringKeyCreator;
import ru.tinkoff.acquiring.sdk.ThreeDsData;
import ru.tinkoff.acquiring.sdk.requests.ChargeRequest;
import ru.tinkoff.acquiring.sdk.requests.ChargeRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.FinishAuthorizeRequest;
import ru.tinkoff.acquiring.sdk.requests.FinishAuthorizeRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.GetCardListRequest;
import ru.tinkoff.acquiring.sdk.requests.GetCardListRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.GetStateRequest;
import ru.tinkoff.acquiring.sdk.requests.GetstateRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.InitRequest;
import ru.tinkoff.acquiring.sdk.requests.InitRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.RemoveCardRequest;
import ru.tinkoff.acquiring.sdk.requests.RemoveCardRequestBuilder;
import ru.tinkoff.acquiring.sdk.responses.GetCardListResponse;

public class AcquiringSdk
extends Journal {
    private final AcquiringApi api;
    private final String terminalKey;
    private final String password;
    private final PublicKey publicKey;

    public AcquiringSdk(String terminalKey, String password, PublicKey publicKey) {
        this.terminalKey = terminalKey;
        this.password = password;
        this.publicKey = publicKey;
        this.api = new AcquiringApi();
    }

    public AcquiringSdk(String terminalKey, String password, String publicKey) {
        this(terminalKey, password, new StringKeyCreator(publicKey));
    }

    public AcquiringSdk(String terminalKey, String password, KeyCreator keyCreator) {
        this(terminalKey, password, keyCreator.create());
    }

    public String getTerminalKey() {
        return this.terminalKey;
    }

    public String getPassword() {
        return this.password;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public Long init(Money amount, String orderId, String customerKey, String description, String payFormTitle, boolean recurrent) {
        InitRequest request = (InitRequest)new InitRequestBuilder(this.password, this.terminalKey).setAmount(amount.getCoins()).setOrderId(orderId).setCustomerKey(customerKey).setDescription(description).setPayForm(payFormTitle).setReccurent(recurrent).build();
        try {
            return this.api.init(request).getPaymentId();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public ThreeDsData finishAuthorize(long paymentId, CardData cardData, String infoEmail) {
        FinishAuthorizeRequest request = (FinishAuthorizeRequest)new FinishAuthorizeRequestBuilder(this.password, this.terminalKey).setPaymentId(paymentId).setSendEmail(infoEmail != null).setCardData(cardData.encode(this.publicKey)).setEmail(infoEmail).build();
        try {
            return this.api.finishAuthorize(request).getThreeDsData();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public Card[] getCardList(String customerKey) {
        GetCardListRequest request = (GetCardListRequest)new GetCardListRequestBuilder(this.password, this.terminalKey).setCustomerKey(customerKey).build();
        try {
            GetCardListResponse response = this.api.getCardList(request);
            Journal.log("GetCardListResponse " + response);
            return response.getCard();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public PaymentInfo charge(long paymentId, long rebillId) {
        ChargeRequest request = (ChargeRequest)new ChargeRequestBuilder(this.password, this.terminalKey).setPaymentId(paymentId).setRebillId(rebillId).build();
        try {
            return this.api.charge(request).getPaymentInfo();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public PaymentStatus getState(long paymentId) {
        GetStateRequest request = (GetStateRequest)new GetstateRequestBuilder(this.password, this.terminalKey).setPaymentId(paymentId).build();
        try {
            return this.api.getState(request).getStatus();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public boolean removeCard(String customerKey, String cardId) {
        RemoveCardRequest request = (RemoveCardRequest)new RemoveCardRequestBuilder(this.password, this.terminalKey).setCustomerKey(customerKey).setCardId(cardId).build();
        try {
            return this.api.removeCard(request).isSuccess();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public String getUrl() {
        return AcquiringApi.getUrl();
    }
}

