/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk;

import java.security.PublicKey;
import ru.tinkoff.acquiring.sdk.CryptoUtils;
import ru.tinkoff.acquiring.sdk.utils.CardValidator;

public class CardData {
    private static final String KEY_CARD_ID = "CardId";
    private static final String KEY_PAN = "PAN";
    private static final String KEY_DATE = "ExpDate";
    private static final String KEY_CVV = "CVV";
    private String pan;
    private String expiryDate;
    private String securityCode;
    private String cardId;

    public CardData(String pan, String expiryDate, String securityCode) {
        this.pan = pan;
        this.expiryDate = expiryDate;
        this.securityCode = securityCode;
    }

    public CardData(String cardId, String securityCode) {
        this.securityCode = securityCode;
        this.cardId = cardId;
    }

    public String encode(PublicKey publicKey) {
        String mergedData;
        this.validate();
        if (this.cardId != null) {
            mergedData = String.format("%s=%s;%s=%s", KEY_CARD_ID, this.cardId, KEY_CVV, this.securityCode);
        } else {
            String date = this.expiryDate.replaceAll("\\D", "");
            mergedData = String.format("%s=%s;%s=%s;%s=%s", KEY_PAN, this.pan, KEY_DATE, date, KEY_CVV, this.securityCode);
        }
        return CryptoUtils.encodeBase64(CryptoUtils.encryptRsa(mergedData, publicKey));
    }

    public String getPan() {
        return this.pan;
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getSecurityCode() {
        return this.securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    private void validate() {
        String wrongField = null;
        if (this.cardId == null) {
            if (!CardValidator.validateNumber(this.pan)) {
                wrongField = "number";
            } else if (!CardValidator.validateExpirationDate(this.expiryDate)) {
                wrongField = "expiration date";
            }
        }
        if (!CardValidator.validateSecurityCode(this.securityCode) && wrongField == null) {
            wrongField = "security code";
        }
        if (wrongField != null) {
            throw new IllegalStateException("Cannot encode card data. Wrong " + wrongField);
        }
    }
}

