/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import ru.tinkoff.acquiring.sdk.CryptoUtils;
import ru.tinkoff.acquiring.sdk.Journal;
import ru.tinkoff.acquiring.sdk.requests.AcquiringRequest;

abstract class AcquiringRequestBuilder<R extends AcquiringRequest> {
    private static final String PASSWORD_KEY = "Password";
    private final String password;
    private final String terminalKey;

    AcquiringRequestBuilder(String password, String terminalKey) {
        this.password = password;
        this.terminalKey = terminalKey;
    }

    protected abstract R getRequest();

    protected abstract void validate();

    public R build() {
        this.validate();
        R request = this.getRequest();
        ((AcquiringRequest)request).setTerminalKey(this.terminalKey);
        ((AcquiringRequest)request).setToken(this.makeToken());
        return this.getRequest();
    }

    protected void validateNonNull(Object value, String name) {
        if (value == null) {
            throw new IllegalStateException(String.format("Unable to build request: field '%s' is null", name));
        }
    }

    protected void validateNonEmpty(String value, String name) {
        this.validateNonNull(value, name);
        if (value.trim().isEmpty()) {
            throw new IllegalStateException(String.format("Unable to build request: field '%s' is empty", name));
        }
    }

    protected void validateZeroOrPositive(Long value, String name) {
        this.validateNonNull(value, name);
        if (value < 0L) {
            throw new IllegalStateException(String.format("Unable to build request: field '%s' is negative", new Object[0]));
        }
    }

    private String makeToken() {
        R request = this.getRequest();
        Map<String, String> parameters = ((AcquiringRequest)request).asMap();
        parameters.remove("Token");
        parameters.put(PASSWORD_KEY, this.password);
        ArrayList<String> sortedKeys = new ArrayList<String>(parameters.keySet());
        Collections.sort(sortedKeys);
        StringBuilder builder = new StringBuilder();
        Set<String> ignoredKes = ((AcquiringRequest)request).getTokenIgnoreFields();
        for (String key : sortedKeys) {
            if (ignoredKes.contains(key)) continue;
            Journal.log(key);
            builder.append(parameters.get(key));
        }
        return CryptoUtils.sha256(builder.toString());
    }
}

