/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import ru.tinkoff.acquiring.sdk.Tax;

public class Item
implements Serializable {
    private static final int QUANTITY_SCALE_FACTOR = 3;
    @SerializedName(value="Name")
    private String name;
    @SerializedName(value="Price")
    private Long price;
    @SerializedName(value="Quantity")
    private double quantity;
    @SerializedName(value="Amount")
    private Long amount;
    @SerializedName(value="Tax")
    private Tax tax;
    @SerializedName(value="Ean13")
    private String ean13;
    @SerializedName(value="ShopCode")
    private String shopCode;

    public Item(String name, Long price, double quantity, Long amount, Tax tax) {
        this.name = name;
        this.price = price;
        this.quantity = Item.round(quantity, 3);
        this.amount = amount;
        this.tax = tax;
    }

    public String getName() {
        return this.name;
    }

    public Long getPrice() {
        return this.price;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public Long getAmount() {
        return this.amount;
    }

    public Tax getTax() {
        return this.tax;
    }

    public String getEan13() {
        return this.ean13;
    }

    public String getShopCode() {
        return this.shopCode;
    }

    public void setEan13(String ean13) {
        this.ean13 = ean13;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    private static double round(double value, int scale) {
        return (double)Math.round(value * Math.pow(10.0, scale)) / Math.pow(10.0, scale);
    }
}

