/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.requests;

import java.util.Map;
import ru.tinkoff.acquiring.sdk.PayType;
import ru.tinkoff.acquiring.sdk.Receipt;
import ru.tinkoff.acquiring.sdk.requests.AcquiringRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.InitRequest;

public final class InitRequestBuilder
extends AcquiringRequestBuilder<InitRequest> {
    private InitRequest request = new InitRequest();

    public InitRequestBuilder(String password, String terminalKey) {
        super(password, terminalKey);
    }

    public InitRequestBuilder setAmount(long value) {
        this.request.setAmount(value);
        return this;
    }

    public InitRequestBuilder setOrderId(String value) {
        this.request.setOrderId(value);
        return this;
    }

    public InitRequestBuilder setCustomerKey(String value) {
        this.request.setCustomerKey(value);
        return this;
    }

    public InitRequestBuilder setDescription(String value) {
        this.request.setDescription(value);
        return this;
    }

    public InitRequestBuilder setPayForm(String value) {
        this.request.setPayForm(value);
        return this;
    }

    public InitRequestBuilder setRecurrent(boolean value) {
        this.request.setRecurrent(value);
        return this;
    }

    public InitRequestBuilder setLanguage(String language) {
        this.request.setLanguage(language);
        return this;
    }

    public InitRequestBuilder setPayType(PayType payType) {
        this.request.setPayType(payType.toString());
        return this;
    }

    public InitRequestBuilder setReceipt(Receipt receipt) {
        this.request.setReceipt(receipt);
        return this;
    }

    public InitRequestBuilder setData(Map<String, String> data) {
        this.request.setData(data);
        return this;
    }

    public InitRequestBuilder setChargeFlag(boolean chargeFlag) {
        this.request.setChargeFlag(chargeFlag);
        return this;
    }

    @Override
    protected void validate() {
        this.validateNonEmpty(this.request.getOrderId(), "Order ID");
        this.validateZeroOrPositive(this.request.getAmount(), "Amount");
    }

    @Override
    protected InitRequest getRequest() {
        return this.request;
    }
}

