/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import ru.tinkoff.acquiring.sdk.AcquiringApiException;
import ru.tinkoff.acquiring.sdk.CardStatus;
import ru.tinkoff.acquiring.sdk.CardStatusSerializer;
import ru.tinkoff.acquiring.sdk.CardsListDeserializer;
import ru.tinkoff.acquiring.sdk.Journal;
import ru.tinkoff.acquiring.sdk.NetworkException;
import ru.tinkoff.acquiring.sdk.PaymentStatus;
import ru.tinkoff.acquiring.sdk.PaymentStatusSerializer;
import ru.tinkoff.acquiring.sdk.Tax;
import ru.tinkoff.acquiring.sdk.TaxSerializer;
import ru.tinkoff.acquiring.sdk.Taxation;
import ru.tinkoff.acquiring.sdk.TaxationSerializer;
import ru.tinkoff.acquiring.sdk.requests.AcquiringRequest;
import ru.tinkoff.acquiring.sdk.requests.AddCardRequest;
import ru.tinkoff.acquiring.sdk.requests.AttachCardRequest;
import ru.tinkoff.acquiring.sdk.requests.ChargeRequest;
import ru.tinkoff.acquiring.sdk.requests.FinishAuthorizeRequest;
import ru.tinkoff.acquiring.sdk.requests.GetAddCardStateRequest;
import ru.tinkoff.acquiring.sdk.requests.GetCardListRequest;
import ru.tinkoff.acquiring.sdk.requests.GetStateRequest;
import ru.tinkoff.acquiring.sdk.requests.InitRequest;
import ru.tinkoff.acquiring.sdk.requests.RemoveCardRequest;
import ru.tinkoff.acquiring.sdk.requests.SubmitRandomAmountRequest;
import ru.tinkoff.acquiring.sdk.responses.AcquiringResponse;
import ru.tinkoff.acquiring.sdk.responses.AddCardResponse;
import ru.tinkoff.acquiring.sdk.responses.AttachCardResponse;
import ru.tinkoff.acquiring.sdk.responses.ChargeResponse;
import ru.tinkoff.acquiring.sdk.responses.FinishAuthorizeResponse;
import ru.tinkoff.acquiring.sdk.responses.GetAddCardStateResponse;
import ru.tinkoff.acquiring.sdk.responses.GetCardListResponse;
import ru.tinkoff.acquiring.sdk.responses.GetStateResponse;
import ru.tinkoff.acquiring.sdk.responses.InitResponse;
import ru.tinkoff.acquiring.sdk.responses.RemoveCardResponse;
import ru.tinkoff.acquiring.sdk.responses.SubmitRandomAmountResponse;

public class AcquiringApi {
    private static final String API_URL_RELEASE = "https://securepay.tinkoff.ru/rest";
    private static final String API_URL_DEBUG = "https://rest-api-test.tcsbank.ru/rest";
    private static final String API_URL_RELEASE_V2 = "https://securepay.tinkoff.ru/v2";
    private static final String API_URL_DEBUG_V2 = "https://rest-api-test.tcsbank.ru/v2";
    private static final int STREAM_BUFFER_SIZE = 4096;
    private static final String API_REQUEST_METHOD = "POST";
    private static final String JSON = "application/json";
    private static final String FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    private static final String[] newMethods = new String[]{"Charge", "FinishAuthorize", "GetCardList", "GetState", "Init", "RemoveCard", "AddCard", "AttachCard", "GetAddCardState", "SubmitRandomAmount"};
    private static final List<String> newMethodsList = Arrays.asList(newMethods);
    private static final String[] performedErrorCodes = new String[]{"0", "104"};
    private static final List<String> performedErrorCodesList = Arrays.asList(performedErrorCodes);
    private final Gson gson = this.createGson();

    static String getUrl(String apiMethod) {
        if (AcquiringApi.useV2Api(apiMethod)) {
            return Journal.isDeveloperMode() ? API_URL_DEBUG_V2 : API_URL_RELEASE_V2;
        }
        return Journal.isDeveloperMode() ? API_URL_DEBUG : API_URL_RELEASE;
    }

    static boolean useV2Api(String apiMethod) {
        return newMethodsList.contains(apiMethod);
    }

    AcquiringApi() {
    }

    InitResponse init(InitRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, InitResponse.class);
    }

    FinishAuthorizeResponse finishAuthorize(FinishAuthorizeRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, FinishAuthorizeResponse.class);
    }

    ChargeResponse charge(ChargeRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, ChargeResponse.class);
    }

    GetStateResponse getState(GetStateRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, GetStateResponse.class);
    }

    GetCardListResponse getCardList(GetCardListRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, GetCardListResponse.class);
    }

    RemoveCardResponse removeCard(RemoveCardRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, RemoveCardResponse.class);
    }

    AddCardResponse addCard(AddCardRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, AddCardResponse.class);
    }

    AttachCardResponse attachCard(AttachCardRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, AttachCardResponse.class);
    }

    GetAddCardStateResponse getAddCardState(GetAddCardStateRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, GetAddCardStateResponse.class);
    }

    SubmitRandomAmountResponse submitRandomAmount(SubmitRandomAmountRequest request) throws AcquiringApiException, NetworkException {
        return this.performRequest(request, SubmitRandomAmountResponse.class);
    }

    private <R extends AcquiringResponse> R performRequest(AcquiringRequest request, Class<R> responseClass) throws NetworkException, AcquiringApiException {
        AcquiringResponse result;
        InputStreamReader responseReader = null;
        OutputStream requestContentStream = null;
        try {
            URL targetUrl = this.prepareURI(request.getApiMethod());
            String requestBody = this.formatRequestBody(request.asMap(), request.getApiMethod());
            HttpURLConnection connection = (HttpURLConnection)targetUrl.openConnection();
            connection.setRequestMethod(API_REQUEST_METHOD);
            Journal.log(String.format("=== Sending %s request to %s", API_REQUEST_METHOD, targetUrl.toString()));
            if (!requestBody.isEmpty()) {
                Journal.log(String.format("===== Parameters: %s", requestBody));
                byte[] requestBodyBytes = requestBody.getBytes();
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-type", AcquiringApi.useV2Api(request.getApiMethod()) ? JSON : FORM_URL_ENCODED);
                connection.setRequestProperty("Content-length", String.valueOf(requestBodyBytes.length));
                requestContentStream = connection.getOutputStream();
                requestContentStream.write(requestBodyBytes);
            }
            responseReader = new InputStreamReader(connection.getInputStream());
            String response = this.read(responseReader);
            Journal.log(String.format("=== Got server response: %s", response));
            result = (AcquiringResponse)this.gson.fromJson(response, responseClass);
            this.closeQuietly(requestContentStream);
            this.closeQuietly(responseReader);
        }
        catch (IOException e) {
            try {
                throw new NetworkException("Unable to execute request " + request.getApiMethod(), e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(requestContentStream);
                this.closeQuietly(responseReader);
                throw throwable;
            }
        }
        if (performedErrorCodesList.contains(result.getErrorCode())) {
            return (R)result;
        }
        if (!result.isSuccess()) {
            String message = result.getMessage();
            String details = result.getDetails();
            if (message != null && details != null) {
                throw new AcquiringApiException(result, String.format("%s: %s", message, details));
            }
            throw new AcquiringApiException(result);
        }
        return (R)result;
    }

    private URL prepareURI(String apiMethod) throws MalformedURLException {
        if (apiMethod == null || apiMethod.isEmpty()) {
            throw new IllegalArgumentException("Cannot prepare URL for request api method is empty or null!");
        }
        StringBuilder builder = new StringBuilder(AcquiringApi.getUrl(apiMethod));
        builder.append("/");
        builder.append(apiMethod);
        return new URL(builder.toString());
    }

    private String formatRequestBody(Map<String, Object> params, String apiMethod) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        if (AcquiringApi.useV2Api(apiMethod)) {
            return this.jsonRequestBody(params);
        }
        return this.encodeRequestBody(params);
    }

    private String jsonRequestBody(Map<String, Object> params) {
        String json = this.gson.toJson(params);
        return json;
    }

    private String encodeRequestBody(Map<String, Object> params) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            try {
                String value = URLEncoder.encode(entry.getValue().toString(), "UTF-8");
                builder.append(entry.getKey());
                builder.append('=');
                builder.append(value);
                builder.append('&');
            }
            catch (UnsupportedEncodingException e) {
                Journal.log(e);
            }
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    private Gson createGson() {
        return new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).registerTypeAdapter(CardStatus.class, (Object)new CardStatusSerializer()).registerTypeAdapter(PaymentStatus.class, (Object)new PaymentStatusSerializer()).registerTypeAdapter(GetCardListResponse.class, (Object)new CardsListDeserializer()).registerTypeAdapter(Tax.class, (Object)new TaxSerializer()).registerTypeAdapter(Taxation.class, (Object)new TaxationSerializer()).create();
    }

    private String read(InputStreamReader reader) throws IOException {
        int read;
        char[] buffer = new char[4096];
        StringBuilder result = new StringBuilder();
        while ((read = reader.read(buffer, 0, 4096)) != -1) {
            result.append(buffer, 0, read);
        }
        return result.toString();
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            Journal.log(e);
        }
    }
}

