/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.utils;

import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CardValidator {
    private static final int[] allowedLengths = new int[]{16, 18, 19, 22};
    private static final String ZERO_NUMBERS_CARD_NUMBER_REGEXP = "[0]{1,}";

    public static boolean validateNumber(String cardNumber) {
        if (CardValidator.isEmpty(cardNumber)) {
            return false;
        }
        if (RegexpValidator.validate(cardNumber, ZERO_NUMBERS_CARD_NUMBER_REGEXP)) {
            return false;
        }
        boolean lengthAllowed = false;
        for (int allowedLength : allowedLengths) {
            if (cardNumber.length() != allowedLength) continue;
            lengthAllowed = true;
        }
        return lengthAllowed && CardValidator.validateWithLuhnAlgorithm(cardNumber);
    }

    public static boolean validateSecurityCode(String cvc) {
        if (CardValidator.isEmpty(cvc)) {
            return false;
        }
        return RegexpValidator.validate(cvc, "^[0-9]{3}$");
    }

    public static boolean validateExpirationDate(String expiryDate) {
        int year;
        int month;
        if (CardValidator.isEmpty(expiryDate) || expiryDate.length() != 5) {
            return false;
        }
        try {
            month = Integer.parseInt(expiryDate.substring(0, 2));
            year = Integer.parseInt(expiryDate.substring(3, 5));
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (month >= 1 && month <= 12) {
            Calendar c = Calendar.getInstance();
            String currentYearStr = Integer.toString(c.get(1)).substring(2);
            int currentMonth = c.get(2) + 1;
            int currentYear = Integer.parseInt(currentYearStr);
            if (year == currentYear && month >= currentMonth) {
                return true;
            }
            if (year > currentYear && year <= currentYear + 20) {
                return true;
            }
        }
        return false;
    }

    private static boolean validateWithLuhnAlgorithm(String cardNumber) {
        int sum = 0;
        int value = 0;
        for (int i = cardNumber.length() - 1; i >= 0; --i) {
            boolean shouldBeDoubled;
            try {
                value = Integer.parseInt(cardNumber.substring(i, i + 1));
            }
            catch (NumberFormatException ex) {
                return false;
            }
            boolean bl = shouldBeDoubled = (cardNumber.length() - i) % 2 == 0;
            if (shouldBeDoubled) {
                sum += (value *= 2) > 9 ? 1 + value % 10 : value;
                continue;
            }
            sum += value;
        }
        return sum % 10 == 0;
    }

    private static boolean isEmpty(CharSequence text) {
        return text == null || text.length() == 0;
    }

    public static class RegexpValidator {
        public static boolean validate(CharSequence string, String regexp) {
            Pattern pattern = Pattern.compile(regexp);
            Matcher matcher = pattern.matcher(string);
            return matcher.matches();
        }
    }
}

