/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import ru.tinkoff.acquiring.sdk.AgentData;
import ru.tinkoff.acquiring.sdk.PaymentMethod;
import ru.tinkoff.acquiring.sdk.PaymentObject;
import ru.tinkoff.acquiring.sdk.SupplierInfo;
import ru.tinkoff.acquiring.sdk.Tax;

public class Item
implements Serializable {
    @SerializedName(value="Name")
    private String name;
    @SerializedName(value="Price")
    private Long price;
    @SerializedName(value="Quantity")
    private double quantity;
    @SerializedName(value="Amount")
    private Long amount;
    @SerializedName(value="Tax")
    private Tax tax;
    @SerializedName(value="Ean13")
    private String ean13;
    @SerializedName(value="ShopCode")
    private String shopCode;
    @SerializedName(value="AgentData")
    private AgentData agentData;
    @SerializedName(value="SupplierInfo")
    private SupplierInfo supplierInfo;
    @SerializedName(value="PaymentObject")
    private PaymentObject paymentObject;
    @SerializedName(value="PaymentMethod")
    private PaymentMethod paymentMethod;

    public Item(String name, Long price, double quantity, Long amount, Tax tax) {
        this.name = name;
        this.price = price;
        this.quantity = Item.round(quantity);
        this.amount = amount;
        this.tax = tax;
    }

    public String getName() {
        return this.name;
    }

    public Long getPrice() {
        return this.price;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public Long getAmount() {
        return this.amount;
    }

    public Tax getTax() {
        return this.tax;
    }

    public String getEan13() {
        return this.ean13;
    }

    public String getShopCode() {
        return this.shopCode;
    }

    public void setEan13(String ean13) {
        this.ean13 = ean13;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    private static double round(double value) {
        return (double)Math.round(value * 1000.0) / 1000.0;
    }

    public AgentData getAgentData() {
        return this.agentData;
    }

    public void setAgentData(AgentData agentData) {
        this.agentData = agentData;
    }

    public SupplierInfo getSupplierInfo() {
        return this.supplierInfo;
    }

    public void setSupplierInfo(SupplierInfo supplierInfo) {
        this.supplierInfo = supplierInfo;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public PaymentObject getPaymentObject() {
        return this.paymentObject;
    }

    public void setPaymentObject(PaymentObject paymentObject) {
        this.paymentObject = paymentObject;
    }
}

