/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Money
implements Serializable,
Comparable<Money> {
    private static final byte COINS_IN_RUBLE = 100;
    private static final byte PRECISION = 2;
    public static final String DEFAULT_INT_DIVIDER = " ";
    public static final String DEFAULT_INT_FRACT_DIVIDER = ",";
    private final long valueCoins;
    private String integralDivider = " ";
    private String integralFractionDivider = ",";

    public static Money ofRubles(long rubles) {
        return new Money(Money.toCoins(rubles));
    }

    public static Money ofRubles(BigDecimal value) {
        BigDecimal precised = value.setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal coins = precised.multiply(new BigDecimal(100, new MathContext(0)));
        return new Money(coins.longValue());
    }

    public static Money ofRubles(double rubles) {
        return Money.ofRubles(new BigDecimal(rubles));
    }

    public static Money ofCoins(long coins) {
        return new Money(coins);
    }

    private static long toCoins(long rubles) {
        return rubles * 100L;
    }

    public Money() {
        this(0L);
    }

    private Money(long valueCoins) {
        this.valueCoins = valueCoins;
    }

    public long getCoins() {
        return this.valueCoins;
    }

    public String toString() {
        long fractional = this.valueCoins % 100L;
        if (fractional == 0L) {
            return this.formatIntPart(this.valueCoins);
        }
        return String.format("%s%s%s", this.formatIntPart(this.valueCoins), this.getIntegralFractionDivider(), this.formatFractionalPart(fractional));
    }

    private String formatFractionalPart(long fractional) {
        return String.format("%02d", fractional);
    }

    public String toHumanReadableString() {
        return this.toString() + " P";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Money money = (Money)o;
        return this.valueCoins == money.valueCoins;
    }

    public int hashCode() {
        return (int)(this.valueCoins ^ this.valueCoins >>> 32);
    }

    public String getIntegralDivider() {
        return this.integralDivider;
    }

    public void setIntegralDivider(String integralDivider) {
        this.integralDivider = integralDivider;
    }

    public String getIntegralFractionDivider() {
        return this.integralFractionDivider;
    }

    public void setIntegralFractionDivider(String integralFractionDivider) {
        this.integralFractionDivider = integralFractionDivider;
    }

    private String formatIntPart(long decimal) {
        if (decimal < 100L) {
            return "0";
        }
        String unformatted = String.valueOf(decimal);
        int headLength = (unformatted = unformatted.substring(0, unformatted.length() - 2)).length() % 3;
        StringBuilder result = headLength > 0 ? new StringBuilder(unformatted.substring(0, headLength)) : new StringBuilder();
        for (int i = headLength; i < unformatted.length(); ++i) {
            int headlessOffset = i - headLength;
            if (headlessOffset % 3 == 0 && i != unformatted.length() - 1) {
                result.append(this.getIntegralDivider());
            }
            result.append(unformatted.charAt(i));
        }
        return result.toString();
    }

    @Override
    public int compareTo(Money o) {
        return Long.valueOf(this.valueCoins).compareTo(o.getCoins());
    }
}

