/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.PublicKey;
import java.util.Enumeration;
import java.util.Map;
import ru.tinkoff.acquiring.sdk.AcquiringApi;
import ru.tinkoff.acquiring.sdk.AcquiringApiException;
import ru.tinkoff.acquiring.sdk.AcquiringSdkException;
import ru.tinkoff.acquiring.sdk.Card;
import ru.tinkoff.acquiring.sdk.CardData;
import ru.tinkoff.acquiring.sdk.CheckType;
import ru.tinkoff.acquiring.sdk.Journal;
import ru.tinkoff.acquiring.sdk.KeyCreator;
import ru.tinkoff.acquiring.sdk.NetworkException;
import ru.tinkoff.acquiring.sdk.PaymentInfo;
import ru.tinkoff.acquiring.sdk.PaymentStatus;
import ru.tinkoff.acquiring.sdk.StringKeyCreator;
import ru.tinkoff.acquiring.sdk.ThreeDsData;
import ru.tinkoff.acquiring.sdk.requests.AddCardRequest;
import ru.tinkoff.acquiring.sdk.requests.AddCardRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.AttachCardRequest;
import ru.tinkoff.acquiring.sdk.requests.AttachCardRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.ChargeRequest;
import ru.tinkoff.acquiring.sdk.requests.ChargeRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.Check3dsVersionRequest;
import ru.tinkoff.acquiring.sdk.requests.Check3dsVersionRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.FinishAuthorizeRequest;
import ru.tinkoff.acquiring.sdk.requests.FinishAuthorizeRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.GetAddCardStateRequest;
import ru.tinkoff.acquiring.sdk.requests.GetAddCardStateRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.GetCardListRequest;
import ru.tinkoff.acquiring.sdk.requests.GetCardListRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.GetStateRequest;
import ru.tinkoff.acquiring.sdk.requests.GetStateRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.InitRequest;
import ru.tinkoff.acquiring.sdk.requests.InitRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.RemoveCardRequest;
import ru.tinkoff.acquiring.sdk.requests.RemoveCardRequestBuilder;
import ru.tinkoff.acquiring.sdk.requests.SubmitRandomAmountRequest;
import ru.tinkoff.acquiring.sdk.requests.SubmitRandomAmountRequestBuilder;
import ru.tinkoff.acquiring.sdk.responses.AddCardResponse;
import ru.tinkoff.acquiring.sdk.responses.AttachCardResponse;
import ru.tinkoff.acquiring.sdk.responses.Check3dsVersionResponse;
import ru.tinkoff.acquiring.sdk.responses.GetAddCardStateResponse;
import ru.tinkoff.acquiring.sdk.responses.GetCardListResponse;
import ru.tinkoff.acquiring.sdk.responses.SubmitRandomAmountResponse;

public class AcquiringSdk
extends Journal {
    private static final int PAY_FORM_MAX_LENGTH = 20;
    private final AcquiringApi api;
    private final String terminalKey;
    private final String password;
    private final PublicKey publicKey;

    public AcquiringSdk(String terminalKey, String password, PublicKey publicKey) {
        this.terminalKey = terminalKey;
        this.password = password;
        this.publicKey = publicKey;
        this.api = new AcquiringApi();
    }

    public AcquiringSdk(String terminalKey, String password, String publicKey) {
        this(terminalKey, password, new StringKeyCreator(publicKey));
    }

    public AcquiringSdk(String terminalKey, String password, KeyCreator keyCreator) {
        this(terminalKey, password, keyCreator.create());
    }

    public String getTerminalKey() {
        return this.terminalKey;
    }

    public String getPassword() {
        return this.password;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public Long init(InitRequestBuilder builder) {
        InitRequest request = (InitRequest)builder.build();
        return this.executeInitRequest(request);
    }

    public Check3dsVersionResponse check3DsVersion(long paymentId, CardData cardData) {
        Check3dsVersionRequest request = (Check3dsVersionRequest)new Check3dsVersionRequestBuilder(this.password, this.terminalKey).setPaymentId(paymentId).setCardData(cardData.encode(this.publicKey)).build();
        try {
            return this.api.check3DsVersion(request);
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public ThreeDsData finishAuthorize(long paymentId, CardData cardData, String infoEmail, Map<String, String> deviceData) {
        FinishAuthorizeRequestBuilder requestBuilder = new FinishAuthorizeRequestBuilder(this.password, this.terminalKey).setPaymentId(paymentId).setSendEmail(infoEmail != null).setCardData(cardData.encode(this.publicKey)).setEmail(infoEmail).setData(deviceData);
        if (deviceData != null) {
            requestBuilder.setIp(this.getIpAddress());
        }
        try {
            return this.api.finishAuthorize((FinishAuthorizeRequest)requestBuilder.build()).getThreeDsData();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public ThreeDsData finishAuthorize(long paymentId, String token, String infoEmail) {
        FinishAuthorizeRequest request = (FinishAuthorizeRequest)new FinishAuthorizeRequestBuilder(this.password, this.terminalKey).setPaymentId(paymentId).setGooglePayToken(token).setSendEmail(infoEmail != null).setEmail(infoEmail).build();
        try {
            return this.api.finishAuthorize(request).getThreeDsData();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public Card[] getCardList(String customerKey) {
        GetCardListRequest request = (GetCardListRequest)new GetCardListRequestBuilder(this.password, this.terminalKey).setCustomerKey(customerKey).build();
        try {
            GetCardListResponse response = this.api.getCardList(request);
            Journal.log("GetCardListResponse " + response);
            return response.getCard();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public PaymentInfo charge(long paymentId, String rebillId) {
        ChargeRequest request = (ChargeRequest)new ChargeRequestBuilder(this.password, this.terminalKey).setPaymentId(paymentId).setRebillId(rebillId).build();
        try {
            return this.api.charge(request).getPaymentInfo();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public PaymentStatus getState(long paymentId) {
        GetStateRequest request = (GetStateRequest)new GetStateRequestBuilder(this.password, this.terminalKey).setPaymentId(paymentId).build();
        try {
            return this.api.getState(request).getStatus();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public boolean removeCard(String customerKey, String cardId) {
        RemoveCardRequest request = (RemoveCardRequest)new RemoveCardRequestBuilder(this.password, this.terminalKey).setCustomerKey(customerKey).setCardId(cardId).build();
        try {
            return this.api.removeCard(request).isSuccess();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public String addCard(String customerKey, CheckType checkType) {
        return this.addCard(customerKey, checkType.toString());
    }

    public String addCard(String customerKey, String checkType) {
        AddCardRequest request = (AddCardRequest)new AddCardRequestBuilder(this.password, this.terminalKey).setCustomerKey(customerKey).setCheckType(checkType).build();
        try {
            AddCardResponse response = this.api.addCard(request);
            return response.getRequestKey();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public AttachCardResponse attachCard(String requestKey, CardData cardData, String email, Map<String, String> data) {
        AttachCardRequest request = (AttachCardRequest)new AttachCardRequestBuilder(this.password, this.terminalKey).setRequestKey(requestKey).setCardData(cardData.encode(this.publicKey)).setEmail(email).setData(data).build();
        try {
            AttachCardResponse response = this.api.attachCard(request);
            return response;
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public GetAddCardStateResponse getAddCardState(String requestKey) {
        GetAddCardStateRequest request = (GetAddCardStateRequest)new GetAddCardStateRequestBuilder(this.password, this.terminalKey).setRequestKey(requestKey).build();
        try {
            GetAddCardStateResponse response = this.api.getAddCardState(request);
            return response;
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public String submitRandomAmount(String requestKey, Long amount) {
        SubmitRandomAmountRequest request = (SubmitRandomAmountRequest)new SubmitRandomAmountRequestBuilder(this.password, this.terminalKey).setRequestKey(requestKey).setAmount(amount).build();
        try {
            SubmitRandomAmountResponse response = this.api.submitRandomAmount(request);
            return response.getCardId();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    public String getUrl(String apiMethod) {
        return AcquiringApi.getUrl(apiMethod);
    }

    private Long executeInitRequest(InitRequest request) {
        try {
            return this.api.init(request).getPaymentId();
        }
        catch (AcquiringApiException | NetworkException e) {
            throw new AcquiringSdkException(e);
        }
    }

    private String getIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface networkInterface = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = networkInterface.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "";
    }
}

