/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk;

public enum PaymentStatus {
    NEW,
    CANCELLED,
    PREAUTHORIZING,
    FORMSHOWED,
    AUTHORIZING,
    THREE_DS_CHECKING,
    THREE_DS_CHECKED,
    AUTHORIZED,
    REVERSING,
    REVERSED,
    CONFIRMING,
    CONFIRMED,
    REFUNDING,
    REFUNDED,
    REJECTED,
    UNKNOWN,
    LOOP_CHECKING,
    COMPLETED,
    AUTH_FAILED;

    private static final String TDS_CHECKING_STRING = "3DS_CHECKING";
    private static final String TDS_CHECKED_STRING = "3DS_CHECKED";

    public static PaymentStatus fromString(String stringValue) {
        switch (stringValue) {
            case "3DS_CHECKING": {
                return THREE_DS_CHECKING;
            }
            case "3DS_CHECKED": {
                return THREE_DS_CHECKED;
            }
        }
        for (PaymentStatus status : PaymentStatus.values()) {
            if (!status.toString().equals(stringValue)) continue;
            return status;
        }
        return UNKNOWN;
    }

    public String toString() {
        if (this == THREE_DS_CHECKING) {
            return TDS_CHECKING_STRING;
        }
        if (this == THREE_DS_CHECKED) {
            return TDS_CHECKED_STRING;
        }
        return super.toString();
    }
}

