/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk;

import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import ru.tinkoff.acquiring.sdk.AcquiringSdkException;
import ru.tinkoff.acquiring.sdk.KeyCreator;
import ru.tinkoff.acquiring.sdk.utils.Base64;

public class StringKeyCreator
implements KeyCreator {
    private String source;

    public StringKeyCreator() {
    }

    public StringKeyCreator(String source) {
        this.source = source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public PublicKey create() {
        if (this.source == null) {
            throw new NullPointerException("StringKeyCreator can't create Key, source String is null, use setSource(String)");
        }
        try {
            byte[] publicBytes = Base64.decode(this.source, 0);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new AcquiringSdkException(e);
        }
    }
}

