/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.models.paysources;

import java.security.PublicKey;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.acquiring.sdk.models.paysources.CardSource;
import ru.tinkoff.acquiring.sdk.utils.CardValidator;
import ru.tinkoff.acquiring.sdk.utils.CryptoUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lru/tinkoff/acquiring/sdk/models/paysources/CardData;", "Lru/tinkoff/acquiring/sdk/models/paysources/CardSource;", "pan", "", "expiryDate", "securityCode", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "()V", "getExpiryDate", "()Ljava/lang/String;", "setExpiryDate", "(Ljava/lang/String;)V", "getPan", "setPan", "getSecurityCode", "setSecurityCode", "encode", "publicKey", "Ljava/security/PublicKey;", "validate", "", "Companion", "core"})
public final class CardData
implements CardSource {
    @NotNull
    private String pan;
    @NotNull
    private String expiryDate;
    @NotNull
    private String securityCode;
    private static final String KEY_PAN = "PAN";
    private static final String KEY_DATE = "ExpDate";
    private static final String KEY_CVV = "CVV";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getPan() {
        return this.pan;
    }

    public final void setPan(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.pan = string;
    }

    @NotNull
    public final String getExpiryDate() {
        return this.expiryDate;
    }

    public final void setExpiryDate(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.expiryDate = string;
    }

    @NotNull
    public final String getSecurityCode() {
        return this.securityCode;
    }

    public final void setSecurityCode(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.securityCode = string;
    }

    @Override
    @NotNull
    public String encode(@NotNull PublicKey publicKey) {
        Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
        this.validate();
        CharSequence charSequence = this.expiryDate;
        String string = "\\D";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "";
        boolean bl2 = false;
        String date = string.replace(charSequence, string2);
        string = StringCompanionObject.INSTANCE;
        string2 = "%s=%s;%s=%s;%s=%s";
        Object[] objectArray = new Object[]{KEY_PAN, this.pan, KEY_DATE, date, KEY_CVV, this.securityCode};
        boolean bl3 = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        String mergedData = string3;
        return CryptoUtils.INSTANCE.encodeBase64(CryptoUtils.INSTANCE.encryptRsa(mergedData, publicKey));
    }

    @Override
    public void validate() {
        String wrongField = null;
        if (!CardValidator.INSTANCE.validateNumber(this.pan)) {
            wrongField = "number";
        } else if (!CardValidator.INSTANCE.validateExpirationDate(this.expiryDate)) {
            wrongField = "expiration date";
        }
        if (!CardValidator.INSTANCE.validateSecurityCode(this.securityCode) && wrongField == null) {
            wrongField = "security code";
        }
        boolean bl = wrongField == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot encode card data. Wrong " + wrongField;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public CardData() {
        this.pan = "";
        this.expiryDate = "";
        this.securityCode = "";
    }

    public CardData(@NotNull String pan, @NotNull String expiryDate, @NotNull String securityCode) {
        Intrinsics.checkParameterIsNotNull((Object)pan, (String)"pan");
        Intrinsics.checkParameterIsNotNull((Object)expiryDate, (String)"expiryDate");
        Intrinsics.checkParameterIsNotNull((Object)securityCode, (String)"securityCode");
        this();
        this.pan = pan;
        this.expiryDate = expiryDate;
        this.securityCode = securityCode;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lru/tinkoff/acquiring/sdk/models/paysources/CardData$Companion;", "", "()V", "KEY_CVV", "", "KEY_DATE", "KEY_PAN", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

