/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.requests;

import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringSdkException;
import ru.tinkoff.acquiring.sdk.models.PaymentSource;
import ru.tinkoff.acquiring.sdk.models.paysources.AttachedCard;
import ru.tinkoff.acquiring.sdk.models.paysources.CardData;
import ru.tinkoff.acquiring.sdk.models.paysources.CardSource;
import ru.tinkoff.acquiring.sdk.models.paysources.GooglePay;
import ru.tinkoff.acquiring.sdk.requests.AcquiringRequest;
import ru.tinkoff.acquiring.sdk.responses.FinishAuthorizeResponse;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 E2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001EB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020201H\u0016J\u001f\u00103\u001a\u00020\u001f2\u0017\u00103\u001a\u0013\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020604\u00a2\u0006\u0002\b7J\u001f\u00108\u001a\u00020\u001f2\u0017\u00108\u001a\u0013\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020604\u00a2\u0006\u0002\b7J4\u0010:\u001a\u0002062\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u000206042\u0016\u0010<\u001a\u0012\u0012\b\u0012\u00060=j\u0002`>\u0012\u0004\u0012\u00020604H\u0016J\b\u0010?\u001a\u000206H\u0002J\u001f\u0010@\u001a\u00020\u001f2\u0017\u0010@\u001a\u0013\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020604\u00a2\u0006\u0002\b7J\u0006\u0010B\u001a\u00020%J\b\u0010C\u001a\u000206H\u0014J.\u0010D\u001a\u000206*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u000202012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\bH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000f\"\u0004\b\u0016\u0010\u0011R\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0010\u0010*\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u0012\u0012\u0004\u0012\u00020\u00050,j\b\u0012\u0004\u0012\u00020\u0005`-8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006F"}, d2={"Lru/tinkoff/acquiring/sdk/requests/FinishAuthorizeRequest;", "Lru/tinkoff/acquiring/sdk/requests/AcquiringRequest;", "Lru/tinkoff/acquiring/sdk/responses/FinishAuthorizeResponse;", "()V", "cardId", "", "cvv", "data", "", "getData", "()Ljava/util/Map;", "setData", "(Ljava/util/Map;)V", "email", "getEmail", "()Ljava/lang/String;", "setEmail", "(Ljava/lang/String;)V", "encodedCardData", "googlePayToken", "ip", "getIp", "setIp", "paymentId", "", "getPaymentId", "()Ljava/lang/Long;", "setPaymentId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "paymentSource", "Lru/tinkoff/acquiring/sdk/models/PaymentSource;", "getPaymentSource", "()Lru/tinkoff/acquiring/sdk/models/PaymentSource;", "setPaymentSource", "(Lru/tinkoff/acquiring/sdk/models/PaymentSource;)V", "sendEmail", "", "getSendEmail", "()Z", "setSendEmail", "(Z)V", "source", "tokenIgnoreFields", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getTokenIgnoreFields$core", "()Ljava/util/HashSet;", "asMap", "", "", "attachedCard", "Lkotlin/Function1;", "Lru/tinkoff/acquiring/sdk/models/paysources/AttachedCard;", "", "Lkotlin/ExtensionFunctionType;", "cardData", "Lru/tinkoff/acquiring/sdk/models/paysources/CardData;", "execute", "onSuccess", "onFailure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "fillPaymentData", "googlePay", "Lru/tinkoff/acquiring/sdk/models/paysources/GooglePay;", "is3DsVersionV2", "validate", "putDataIfNonNull", "Companion", "core"})
public final class FinishAuthorizeRequest
extends AcquiringRequest<FinishAuthorizeResponse> {
    private boolean sendEmail;
    @Nullable
    private Long paymentId;
    @Nullable
    private String email;
    @Nullable
    private PaymentSource paymentSource;
    @Nullable
    private Map<String, String> data;
    @Nullable
    private String ip;
    private String cardId;
    private String cvv;
    private String source;
    private String googlePayToken;
    private String encodedCardData;
    private static final String GOOGLE_PAY = "GooglePay";
    public static final Companion Companion = new Companion(null);

    public final boolean getSendEmail() {
        return this.sendEmail;
    }

    public final void setSendEmail(boolean bl) {
        this.sendEmail = bl;
    }

    @Nullable
    public final Long getPaymentId() {
        return this.paymentId;
    }

    public final void setPaymentId(@Nullable Long l) {
        this.paymentId = l;
    }

    @Nullable
    public final String getEmail() {
        return this.email;
    }

    public final void setEmail(@Nullable String string) {
        this.email = string;
    }

    @Nullable
    public final PaymentSource getPaymentSource() {
        return this.paymentSource;
    }

    public final void setPaymentSource(@Nullable PaymentSource paymentSource) {
        this.paymentSource = paymentSource;
    }

    @Nullable
    public final Map<String, String> getData() {
        return this.data;
    }

    public final void setData(@Nullable Map<String, String> map) {
        this.data = map;
    }

    @Nullable
    public final String getIp() {
        return this.ip;
    }

    public final void setIp(@Nullable String string) {
        this.ip = string;
    }

    @Override
    @NotNull
    public HashSet<String> getTokenIgnoreFields$core() {
        HashSet<String> result = new HashSet<String>();
        result.add("CardId");
        result.add("CVV");
        result.add("DATA");
        return result;
    }

    @Override
    @NotNull
    public Map<String, Object> asMap() {
        Map<String, Object> map = super.asMap();
        this.putIfNotNull(map, "PaymentId", String.valueOf(this.paymentId));
        this.putIfNotNull(map, "SendEmail", this.sendEmail);
        this.putIfNotNull(map, "CardData", this.encodedCardData);
        this.putIfNotNull(map, "CardId", this.cardId);
        this.putIfNotNull(map, "CVV", this.cvv);
        this.putIfNotNull(map, "InfoEmail", this.email);
        this.putIfNotNull(map, "Source", this.source);
        this.putIfNotNull(map, "EncryptedPaymentData", this.googlePayToken);
        this.putIfNotNull(map, "IP", this.ip);
        if (this.data != null) {
            this.putDataIfNonNull(map, this.data);
        }
        return map;
    }

    @Override
    protected void validate() {
        block1: {
            PaymentSource paymentSource;
            block0: {
                this.validate(this.paymentSource, "PaymentSource");
                this.validate(this.paymentId, "PaymentId");
                paymentSource = this.paymentSource;
                if (!(paymentSource instanceof CardData) && !(paymentSource instanceof AttachedCard)) break block0;
                this.validate(this.encodedCardData, "CardData");
                break block1;
            }
            if (!(paymentSource instanceof GooglePay)) break block1;
            this.validate(this.googlePayToken, "EncryptedPaymentData");
        }
    }

    @Override
    public void execute(@NotNull Function1<? super FinishAuthorizeResponse, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailure) {
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onFailure, (String)"onFailure");
        this.fillPaymentData();
        super.performRequest(this, FinishAuthorizeResponse.class, onSuccess, onFailure);
    }

    @NotNull
    public final PaymentSource attachedCard(@NotNull Function1<? super AttachedCard, Unit> attachedCard) {
        Intrinsics.checkParameterIsNotNull(attachedCard, (String)"attachedCard");
        AttachedCard attachedCard2 = new AttachedCard();
        boolean bl = false;
        boolean bl2 = false;
        attachedCard.invoke((Object)attachedCard2);
        return attachedCard2;
    }

    @NotNull
    public final PaymentSource googlePay(@NotNull Function1<? super GooglePay, Unit> googlePay) {
        Intrinsics.checkParameterIsNotNull(googlePay, (String)"googlePay");
        GooglePay googlePay2 = new GooglePay(null, 1, null);
        boolean bl = false;
        boolean bl2 = false;
        googlePay.invoke((Object)googlePay2);
        return googlePay2;
    }

    @NotNull
    public final PaymentSource cardData(@NotNull Function1<? super CardData, Unit> cardData) {
        Intrinsics.checkParameterIsNotNull(cardData, (String)"cardData");
        CardData cardData2 = new CardData();
        boolean bl = false;
        boolean bl2 = false;
        cardData.invoke((Object)cardData2);
        return cardData2;
    }

    public final boolean is3DsVersionV2() {
        return this.data != null && this.ip != null;
    }

    private final void fillPaymentData() {
        PaymentSource data = null;
        PaymentSource paymentSource = this.paymentSource;
        if (paymentSource instanceof CardSource) {
            PaymentSource paymentSource2 = this.paymentSource;
            if (paymentSource2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type ru.tinkoff.acquiring.sdk.models.paysources.CardSource");
            }
            PaymentSource paymentSource3 = data = (PaymentSource)((CardSource)paymentSource2);
            if (paymentSource3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"data");
            }
            this.encodedCardData = ((CardSource)paymentSource3).encode(this.getPublicKey$core());
        } else if (paymentSource instanceof GooglePay) {
            PaymentSource paymentSource4 = this.paymentSource;
            if (paymentSource4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type ru.tinkoff.acquiring.sdk.models.paysources.GooglePay");
            }
            PaymentSource paymentSource5 = data = (PaymentSource)((GooglePay)paymentSource4);
            if (paymentSource5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"data");
            }
            this.googlePayToken = ((GooglePay)paymentSource5).getGooglePayToken();
            this.source = GOOGLE_PAY;
        } else {
            throw (Throwable)new AcquiringSdkException(new IllegalStateException("Unknown type in 'paymentSource'"));
        }
    }

    private final void putDataIfNonNull(@NotNull Map<String, Object> $this$putDataIfNonNull, Map<String, String> data) {
        if (data != null) {
            $this$putDataIfNonNull.put("DATA", MapsKt.toMutableMap(data));
        }
    }

    public FinishAuthorizeRequest() {
        super("FinishAuthorize");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lru/tinkoff/acquiring/sdk/requests/FinishAuthorizeRequest$Companion;", "", "()V", "GOOGLE_PAY", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

