/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.network;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.acquiring.sdk.AcquiringSdk;
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringApiException;
import ru.tinkoff.acquiring.sdk.exceptions.NetworkException;
import ru.tinkoff.acquiring.sdk.models.enums.CardStatus;
import ru.tinkoff.acquiring.sdk.models.enums.ResponseStatus;
import ru.tinkoff.acquiring.sdk.models.enums.Tax;
import ru.tinkoff.acquiring.sdk.models.enums.Taxation;
import ru.tinkoff.acquiring.sdk.network.AcquiringApi;
import ru.tinkoff.acquiring.sdk.network.NetworkClient;
import ru.tinkoff.acquiring.sdk.requests.AcquiringRequest;
import ru.tinkoff.acquiring.sdk.requests.FinishAuthorizeRequest;
import ru.tinkoff.acquiring.sdk.responses.AcquiringResponse;
import ru.tinkoff.acquiring.sdk.responses.ErrorResponse;
import ru.tinkoff.acquiring.sdk.responses.GetCardListResponse;
import ru.tinkoff.acquiring.sdk.utils.serialization.CardStatusSerializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.CardsListDeserializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.PaymentStatusSerializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.SerializableExclusionStrategy;
import ru.tinkoff.acquiring.sdk.utils.serialization.TaxSerializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.TaxationSerializer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J_\u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000e2\u0016\u0010\u000f\u001a\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00060\u000eH\u0000\u00a2\u0006\u0002\b\u0012JB\u0010\u0013\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\u0014\u001a\u0002H\u00072!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00060\u000eH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0004H\u0002J\u001c\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00010\"H\u0002J&\u0010#\u001a\u00020 2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0001\u0018\u00010\"2\u0006\u0010$\u001a\u00020 H\u0002J\u001c\u0010%\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00010\"H\u0002J4\u0010&\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J4\u0010)\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0012\u0010+\u001a\u00020,2\b\u0010$\u001a\u0004\u0018\u00010 H\u0002J\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lru/tinkoff/acquiring/sdk/network/NetworkClient;", "", "()V", "gson", "Lcom/google/gson/Gson;", "call", "", "R", "Lru/tinkoff/acquiring/sdk/responses/AcquiringResponse;", "request", "Lru/tinkoff/acquiring/sdk/requests/AcquiringRequest;", "responseClass", "Ljava/lang/Class;", "onSuccess", "Lkotlin/Function1;", "onFailure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "call$core", "checkResult", "result", "onChecked", "", "Lkotlin/ParameterName;", "name", "isSuccess", "(Lru/tinkoff/acquiring/sdk/responses/AcquiringResponse;Lkotlin/jvm/functions/Function1;)V", "closeQuietly", "closeable", "Ljava/io/Closeable;", "createGson", "encodeRequestBody", "", "params", "", "formatRequestBody", "apiMethod", "jsonRequestBody", "prepareBody", "onReady", "", "prepareConnection", "Ljava/net/HttpURLConnection;", "prepareURL", "Ljava/net/URL;", "read", "reader", "Ljava/io/InputStreamReader;", "core"})
public final class NetworkClient {
    private final Gson gson = this.createGson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <R extends AcquiringResponse> void call$core(@NotNull AcquiringRequest<R> request, @NotNull Class<R> responseClass, @NotNull Function1<? super R, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailure) {
        void requestContentStream;
        Intrinsics.checkParameterIsNotNull(request, (String)"request");
        Intrinsics.checkParameterIsNotNull(responseClass, (String)"responseClass");
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onFailure, (String)"onFailure");
        AcquiringResponse result = null;
        String response = null;
        InputStreamReader responseReader = null;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        try {
            int responseCode;
            void connection;
            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
            objectRef2.element = null;
            this.prepareBody(request, (Function1<? super byte[], Unit>)((Function1)new Function1<byte[], Unit>(this, request, (Ref.ObjectRef)connection, (Ref.ObjectRef)requestContentStream){
                final /* synthetic */ NetworkClient this$0;
                final /* synthetic */ AcquiringRequest $request;
                final /* synthetic */ Ref.ObjectRef $connection;
                final /* synthetic */ Ref.ObjectRef $requestContentStream;

                public final void invoke(@NotNull byte[] body) {
                    Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                    NetworkClient.access$prepareConnection(this.this$0, this.$request, (Function1)new Function1<HttpURLConnection, Unit>(this, body){
                        final /* synthetic */ call.1 this$0;
                        final /* synthetic */ byte[] $body;

                        public final void invoke(@NotNull HttpURLConnection it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            Object object = this.this$0.$connection.element = it;
                            if (object == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                            }
                            ((HttpURLConnection)object).setRequestProperty("Content-length", String.valueOf(this.$body.length));
                            Ref.ObjectRef objectRef = this.this$0.$requestContentStream;
                            Object object2 = this.this$0.$connection.element;
                            if (object2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                            }
                            objectRef.element = ((HttpURLConnection)object2).getOutputStream();
                            OutputStream outputStream = (OutputStream)this.this$0.$requestContentStream.element;
                            if (outputStream != null) {
                                outputStream.write(this.$body);
                            }
                            StringBuilder stringBuilder = new StringBuilder().append("=== Sending POST request to ");
                            Object object3 = this.this$0.$connection.element;
                            if (object3 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                            }
                            AcquiringSdk.AsdkLogger.log(stringBuilder.append(((HttpURLConnection)object3).getURL()).toString());
                        }
                        {
                            this.this$0 = var1_1;
                            this.$body = byArray;
                            super(1);
                        }
                    });
                }
                {
                    this.this$0 = networkClient;
                    this.$request = acquiringRequest;
                    this.$connection = objectRef;
                    this.$requestContentStream = objectRef2;
                    super(1);
                }
            }));
            Object object = connection.element;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
            }
            if ((responseCode = ((HttpURLConnection)object).getResponseCode()) == 200) {
                Object object2 = connection.element;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                }
                responseReader = new InputStreamReader(((HttpURLConnection)object2).getInputStream());
                response = this.read(responseReader);
                AcquiringSdk.AsdkLogger.log("=== Got server response: " + response);
                Object object3 = this.gson.fromJson(response, responseClass);
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"gson.fromJson(response, responseClass)");
                result = (AcquiringResponse)object3;
                this.checkResult(result, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(request, onSuccess, result, onFailure){
                    final /* synthetic */ AcquiringRequest $request;
                    final /* synthetic */ Function1 $onSuccess;
                    final /* synthetic */ AcquiringResponse $result;
                    final /* synthetic */ Function1 $onFailure;

                    public final void invoke(boolean isSuccess) {
                        if (!this.$request.isDisposed()) {
                            if (isSuccess) {
                                AcquiringSdk.AsdkLogger.log("=== Request done with success, sent for processing");
                                this.$onSuccess.invoke((Object)this.$result);
                            } else {
                                AcquiringSdk.AsdkLogger.log("=== Request done with fail");
                                StringBuilder stringBuilder = new StringBuilder();
                                String string = this.$result.getMessage();
                                if (string == null) {
                                    string = "";
                                }
                                StringBuilder stringBuilder2 = stringBuilder.append(string).append(' ');
                                String string2 = this.$result.getDetails();
                                if (string2 == null) {
                                    string2 = "";
                                }
                                this.$onFailure.invoke((Object)new AcquiringApiException(this.$result, stringBuilder2.append(string2).toString()));
                            }
                        }
                    }
                    {
                        this.$request = acquiringRequest;
                        this.$onSuccess = function1;
                        this.$result = acquiringResponse;
                        this.$onFailure = function12;
                        super(1);
                    }
                }));
            } else {
                Object object4 = connection.element;
                if (object4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                }
                responseReader = new InputStreamReader(((HttpURLConnection)object4).getErrorStream());
                response = this.read(responseReader);
                CharSequence charSequence = response;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    AcquiringSdk.AsdkLogger.log("=== Got server error response: " + response);
                } else {
                    AcquiringSdk.AsdkLogger.log("=== Got server error response code: " + responseCode);
                }
                if (!request.isDisposed()) {
                    onFailure.invoke((Object)new NetworkException("Unable to performRequest request " + request.getApiMethod$core()));
                }
            }
        }
        catch (IOException e) {
            if (!request.isDisposed()) {
                onFailure.invoke((Object)new NetworkException("Unable to performRequest request " + request.getApiMethod$core(), e));
            }
        }
        catch (JsonParseException e) {
            if (!request.isDisposed()) {
                ErrorResponse errorResponse;
                ErrorResponse errorResponse2 = errorResponse = (ErrorResponse)this.gson.fromJson(response, ErrorResponse.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)errorResponse2, (String)"errorResponse");
                AcquiringResponse acquiringResponse = errorResponse2;
                StringBuilder stringBuilder = new StringBuilder();
                String string = errorResponse.getMessage();
                if (string == null) {
                    string = "";
                }
                StringBuilder stringBuilder2 = stringBuilder.append(string).append(' ');
                String string2 = errorResponse.getDetails();
                if (string2 == null) {
                    string2 = "";
                }
                onFailure.invoke((Object)new AcquiringApiException(acquiringResponse, stringBuilder2.append(string2).toString()));
            }
        }
        finally {
            this.closeQuietly(responseReader);
            this.closeQuietly((OutputStream)requestContentStream.element);
        }
    }

    private final <R extends AcquiringResponse> void prepareConnection(AcquiringRequest<R> request, Function1<? super HttpURLConnection, Unit> onReady) {
        URL targetUrl = this.prepareURL(request.getApiMethod$core());
        URLConnection uRLConnection = targetUrl.openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        boolean bl = false;
        boolean bl2 = false;
        HttpURLConnection $this$with = connection;
        boolean bl3 = false;
        $this$with.setRequestMethod("POST");
        $this$with.setConnectTimeout(40000);
        $this$with.setReadTimeout(40000);
        $this$with.setDoOutput(true);
        $this$with.setRequestProperty("Content-type", AcquiringApi.INSTANCE.useV1Api$core(request.getApiMethod$core()) ? "application/x-www-form-urlencoded" : "application/json");
        if (request instanceof FinishAuthorizeRequest && ((FinishAuthorizeRequest)request).is3DsVersionV2()) {
            $this$with.setRequestProperty("User-Agent", System.getProperty("http.agent"));
            $this$with.setRequestProperty("Accept", "application/json");
        }
        onReady.invoke((Object)connection);
    }

    private final <R extends AcquiringResponse> void prepareBody(AcquiringRequest<R> request, Function1<? super byte[], Unit> onReady) {
        String requestBody = this.formatRequestBody(request.asMap(), request.getApiMethod$core());
        AcquiringSdk.AsdkLogger.log("=== Parameters: " + requestBody);
        String string = requestBody;
        Function1<? super byte[], Unit> function1 = onReady;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        function1.invoke((Object)byArray2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final <R extends AcquiringResponse> void checkResult(R result, Function1<? super Boolean, Unit> onChecked) {
        if (CollectionsKt.contains((Iterable)AcquiringApi.INSTANCE.getPerformedErrorCodesList$core(), (Object)result.getErrorCode())) {
            Boolean bl = result.isSuccess();
            if (bl == null) {
                Intrinsics.throwNpe();
            }
            if (bl.booleanValue()) {
                onChecked.invoke((Object)true);
                return;
            }
        }
        onChecked.invoke((Object)false);
    }

    private final URL prepareURL(String apiMethod) throws MalformedURLException {
        block3: {
            block2: {
                if (apiMethod == null) break block2;
                CharSequence charSequence = apiMethod;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block3;
            }
            throw (Throwable)new IllegalArgumentException("Cannot prepare URL for request api method is empty or null!");
        }
        StringBuilder builder = new StringBuilder(AcquiringApi.INSTANCE.getUrl(apiMethod));
        builder.append("/");
        builder.append(apiMethod);
        return new URL(builder.toString());
    }

    private final String formatRequestBody(Map<String, ? extends Object> params, String apiMethod) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        return AcquiringApi.INSTANCE.useV1Api$core(apiMethod) ? this.encodeRequestBody(params) : this.jsonRequestBody(params);
    }

    private final String jsonRequestBody(Map<String, ? extends Object> params) {
        String string = this.gson.toJson(params);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(params)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String encodeRequestBody(Map<String, ? extends Object> params) {
        StringBuilder builder = new StringBuilder();
        Object object = params;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> entry;
            Map.Entry<String, ? extends Object> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Object value1 = entry2.getValue();
            try {
                void key;
                String value = URLEncoder.encode(value1.toString(), "UTF-8");
                builder.append((String)key);
                builder.append('=');
                builder.append(value);
                builder.append('&');
            }
            catch (UnsupportedEncodingException e) {
                AcquiringSdk.AsdkLogger.log(e);
            }
        }
        builder.setLength(builder.length() - 1);
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String read(InputStreamReader reader) throws IOException {
        void read2;
        char[] buffer = new char[4096];
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = -1;
        StringBuilder result = new StringBuilder();
        while (((Number)((Function0)new Function0<Integer>((Ref.IntRef)read2, reader, buffer){
            final /* synthetic */ Ref.IntRef $read;
            final /* synthetic */ InputStreamReader $reader;
            final /* synthetic */ char[] $buffer;

            public final int invoke() {
                this.$read.element = this.$reader.read(this.$buffer, 0, 4096);
                return this.$read.element;
            }
            {
                this.$read = intRef;
                this.$reader = inputStreamReader;
                this.$buffer = cArray;
                super(0);
            }
        }).invoke()).intValue() != -1) {
            result.append(buffer, 0, read2.element);
        }
        String string = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    private final void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            AcquiringSdk.AsdkLogger.log(e);
        }
    }

    private final Gson createGson() {
        Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128, 8}).setExclusionStrategies(new ExclusionStrategy[]{new SerializableExclusionStrategy()}).registerTypeAdapter((Type)((Object)CardStatus.class), (Object)new CardStatusSerializer()).registerTypeAdapter((Type)((Object)ResponseStatus.class), (Object)new PaymentStatusSerializer()).registerTypeAdapter((Type)((Object)GetCardListResponse.class), (Object)new CardsListDeserializer()).registerTypeAdapter((Type)((Object)Tax.class), (Object)new TaxSerializer()).registerTypeAdapter((Type)((Object)Taxation.class), (Object)new TaxationSerializer()).create();
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"GsonBuilder()\n          \u2026                .create()");
        return gson;
    }

    public static final /* synthetic */ void access$prepareConnection(NetworkClient $this, AcquiringRequest request, Function1 onReady) {
        $this.prepareConnection(request, (Function1<? super HttpURLConnection, Unit>)onReady);
    }
}

