/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.network;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.acquiring.sdk.AcquiringSdk;
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringApiException;
import ru.tinkoff.acquiring.sdk.exceptions.NetworkException;
import ru.tinkoff.acquiring.sdk.models.enums.CardStatus;
import ru.tinkoff.acquiring.sdk.models.enums.ResponseStatus;
import ru.tinkoff.acquiring.sdk.models.enums.Tax;
import ru.tinkoff.acquiring.sdk.models.enums.Taxation;
import ru.tinkoff.acquiring.sdk.network.AcquiringApi;
import ru.tinkoff.acquiring.sdk.requests.AcquiringRequest;
import ru.tinkoff.acquiring.sdk.requests.FinishAuthorizeRequest;
import ru.tinkoff.acquiring.sdk.responses.AcquiringResponse;
import ru.tinkoff.acquiring.sdk.responses.GetCardListResponse;
import ru.tinkoff.acquiring.sdk.utils.serialization.CardStatusSerializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.CardsListDeserializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.PaymentStatusSerializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.SerializableExclusionStrategy;
import ru.tinkoff.acquiring.sdk.utils.serialization.TaxSerializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.TaxationSerializer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J_\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\t0\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\b0\u00102\u0016\u0010\u0011\u001a\u0012\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\u0004\u0012\u00020\b0\u0010H\u0000\u00a2\u0006\u0002\b\u0014J%\u0010\u0015\u001a\u00020\u0016\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0000\u00a2\u0006\u0002\b\u0017JB\u0010\u0018\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u0019\u001a\u0002H\t2!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\b0\u0010H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0010\u0010$\u001a\u00020%*\u0006\u0012\u0002\b\u00030\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lru/tinkoff/acquiring/sdk/network/NetworkClient;", "", "()V", "gson", "Lcom/google/gson/Gson;", "okHttpClient", "Lokhttp3/OkHttpClient;", "call", "", "R", "Lru/tinkoff/acquiring/sdk/responses/AcquiringResponse;", "request", "Lru/tinkoff/acquiring/sdk/requests/AcquiringRequest;", "responseClass", "Ljava/lang/Class;", "onSuccess", "Lkotlin/Function1;", "onFailure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "call$core", "callRaw", "Lokhttp3/Response;", "callRaw$core", "checkResult", "result", "onChecked", "", "Lkotlin/ParameterName;", "name", "isSuccess", "(Lru/tinkoff/acquiring/sdk/responses/AcquiringResponse;Lkotlin/jvm/functions/Function1;)V", "prepareURL", "Ljava/net/URL;", "apiMethod", "", "httpRequest", "Lokhttp3/Request;", "Companion", "core"})
public final class NetworkClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(40000L, TimeUnit.MILLISECONDS).readTimeout(40000L, TimeUnit.MILLISECONDS).build();
    @NotNull
    private final Gson gson = Companion.createGson();

    public final <R extends AcquiringResponse> void call$core(@NotNull AcquiringRequest<R> request, @NotNull Class<R> responseClass, @NotNull Function1<? super R, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailure) {
        block9: {
            Intrinsics.checkNotNullParameter(request, (String)"request");
            Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
            Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
            Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
            String response = null;
            try {
                Request httpRequest = this.httpRequest(request);
                Call call2 = this.okHttpClient.newCall(httpRequest);
                Response httpResponse = call2.execute();
                AcquiringSdk.Companion.log("=== Sending " + httpRequest.method() + " request to " + httpRequest.url());
                int responseCode = httpResponse.code();
                ResponseBody responseBody = httpResponse.body();
                String string = response = responseBody == null ? null : responseBody.string();
                if (responseCode == 200) {
                    AcquiringSdk.Companion.log(Intrinsics.stringPlus((String)"=== Got server response: ", (Object)response));
                    AcquiringResponse result = (AcquiringResponse)this.gson.fromJson(response, responseClass);
                    this.checkResult(result, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(request, onSuccess, result, onFailure){
                        final /* synthetic */ AcquiringRequest<R> $request;
                        final /* synthetic */ Function1<R, Unit> $onSuccess;
                        final /* synthetic */ R $result;
                        final /* synthetic */ Function1<Exception, Unit> $onFailure;
                        {
                            this.$request = $request;
                            this.$onSuccess = $onSuccess;
                            this.$result = $result;
                            this.$onFailure = $onFailure;
                            super(1);
                        }

                        public final void invoke(boolean isSuccess) {
                            if (!this.$request.isDisposed()) {
                                if (isSuccess) {
                                    AcquiringSdk.Companion.log("=== Request done with success, sent for processing");
                                    R r = this.$result;
                                    Intrinsics.checkNotNullExpressionValue(r, (String)"result");
                                    this.$onSuccess.invoke(r);
                                } else {
                                    AcquiringSdk.Companion.log("=== Request done with fail");
                                    R r = this.$result;
                                    Intrinsics.checkNotNullExpressionValue(r, (String)"result");
                                    StringBuilder stringBuilder = new StringBuilder();
                                    String string = ((AcquiringResponse)this.$result).getMessage();
                                    if (string == null) {
                                        string = "";
                                    }
                                    StringBuilder stringBuilder2 = stringBuilder.append(string).append(' ');
                                    String string2 = ((AcquiringResponse)this.$result).getDetails();
                                    if (string2 == null) {
                                        string2 = "";
                                    }
                                    this.$onFailure.invoke((Object)new AcquiringApiException((AcquiringResponse)r, stringBuilder2.append(string2).toString()));
                                }
                            }
                        }
                    }));
                } else {
                    CharSequence charSequence = response;
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        AcquiringSdk.Companion.log(Intrinsics.stringPlus((String)"=== Got server error response: ", (Object)response));
                    } else {
                        AcquiringSdk.Companion.log(Intrinsics.stringPlus((String)"=== Got server error response code: ", (Object)responseCode));
                    }
                    if (!request.isDisposed()) {
                        onFailure.invoke((Object)new NetworkException(Intrinsics.stringPlus((String)"Unable to performRequest request ", (Object)request.getApiMethod$core())));
                    }
                }
            }
            catch (IOException e) {
                if (!request.isDisposed()) {
                    onFailure.invoke((Object)new NetworkException(Intrinsics.stringPlus((String)"Unable to performRequest request ", (Object)request.getApiMethod$core()), e));
                }
            }
            catch (JsonParseException e) {
                if (request.isDisposed()) break block9;
                onFailure.invoke((Object)new AcquiringApiException(Intrinsics.stringPlus((String)"Invalid response. ", response), e));
            }
        }
    }

    @NotNull
    public final <R extends AcquiringResponse> Response callRaw$core(@NotNull AcquiringRequest<R> request) {
        Response response;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        try {
            Request httpRequest = this.httpRequest(request);
            Call call2 = this.okHttpClient.newCall(httpRequest);
            AcquiringSdk.Companion.log("=== Sending " + httpRequest.method() + " request to " + httpRequest.url());
            response = call2.execute();
        }
        catch (IOException e) {
            AcquiringSdk.Companion.log("=== Receive error " + e.getMessage() + " on method " + request.getHttpRequestMethod() + ' ' + request.getApiMethod$core());
            throw new NetworkException(Intrinsics.stringPlus((String)"Unable to performRequest request ", (Object)request.getApiMethod$core()), e);
        }
        return response;
    }

    private final Request httpRequest(AcquiringRequest<?> $this$httpRequest) {
        Request.Builder builder;
        Request.Builder builder2 = builder = new Request.Builder();
        boolean bl = false;
        builder2.url(this.prepareURL($this$httpRequest.getApiMethod$core()));
        String string = $this$httpRequest.getHttpRequestMethod();
        if (Intrinsics.areEqual((Object)string, (Object)"GET")) {
            builder2.get();
        } else if (Intrinsics.areEqual((Object)string, (Object)"POST")) {
            String body = $this$httpRequest.getRequestBody();
            AcquiringSdk.Companion.log(Intrinsics.stringPlus((String)"=== Parameters: ", (Object)body));
            builder2.post(RequestBody.Companion.create(body, MediaType.Companion.get($this$httpRequest.getContentType())));
        }
        if ($this$httpRequest instanceof FinishAuthorizeRequest && ((FinishAuthorizeRequest)$this$httpRequest).is3DsVersionV2()) {
            string = System.getProperty("http.agent");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"http.agent\")");
            builder2.header("User-Agent", string);
            builder2.header("Accept", "application/json");
        }
        Map $this$forEach$iv = $this$httpRequest.getHeaders$core();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$key$value = element$iv = iterator.next();
            boolean bl2 = false;
            String key = (String)$dstr$key$value.getKey();
            String value = (String)$dstr$key$value.getValue();
            builder2.header(key, value);
        }
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final <R extends AcquiringResponse> void checkResult(R result, Function1<? super Boolean, Unit> onChecked) {
        if (Intrinsics.areEqual((Object)result.getErrorCode(), (Object)"0")) {
            Boolean bl = result.isSuccess();
            Intrinsics.checkNotNull((Object)bl);
            if (bl.booleanValue()) {
                onChecked.invoke((Object)true);
                return;
            }
        }
        onChecked.invoke((Object)false);
    }

    private final URL prepareURL(String apiMethod) throws MalformedURLException {
        CharSequence charSequence = apiMethod;
        if (charSequence == null || charSequence.length() == 0) {
            throw new IllegalArgumentException("Cannot prepare URL for request api method is empty or null!");
        }
        StringBuilder builder = new StringBuilder(AcquiringApi.INSTANCE.getUrl(apiMethod));
        builder.append("/");
        builder.append(apiMethod);
        return new URL(builder.toString());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lru/tinkoff/acquiring/sdk/network/NetworkClient$Companion;", "", "()V", "createGson", "Lcom/google/gson/Gson;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson createGson() {
            Object[] objectArray = new int[]{128, 8};
            GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping().excludeFieldsWithModifiers(objectArray);
            objectArray = new ExclusionStrategy[1];
            objectArray[0] = (int)new SerializableExclusionStrategy();
            Gson gson = gsonBuilder.setExclusionStrategies((ExclusionStrategy[])objectArray).registerTypeAdapter((Type)((Object)CardStatus.class), (Object)new CardStatusSerializer()).registerTypeAdapter((Type)((Object)ResponseStatus.class), (Object)new PaymentStatusSerializer()).registerTypeAdapter((Type)((Object)GetCardListResponse.class), (Object)new CardsListDeserializer()).registerTypeAdapter((Type)((Object)Tax.class), (Object)new TaxSerializer()).registerTypeAdapter((Type)((Object)Taxation.class), (Object)new TaxationSerializer()).create();
            Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder()\n          \u2026                .create()");
            return gson;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

