/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0010\u0010\u000b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lru/tinkoff/acquiring/sdk/utils/CardValidator;", "", "()V", "CVC_REGEXP", "", "ZERO_NUMBERS_CARD_NUMBER_REGEXP", "allowedLengths", "Lkotlin/ranges/IntRange;", "validateExpirationDate", "", "expiryDate", "validateNumber", "cardNumber", "validateSecurityCode", "cvc", "validateWithLuhnAlgorithm", "RegexpValidator", "core"})
public final class CardValidator {
    @NotNull
    public static final CardValidator INSTANCE = new CardValidator();
    @NotNull
    private static final IntRange allowedLengths = new IntRange(13, 28);
    @NotNull
    private static final String ZERO_NUMBERS_CARD_NUMBER_REGEXP = "[0]{1,}";
    @NotNull
    private static final String CVC_REGEXP = "^[0-9]{3}$";

    private CardValidator() {
    }

    public final boolean validateNumber(@Nullable String cardNumber) {
        int n;
        if (cardNumber == null) {
            return false;
        }
        if (RegexpValidator.INSTANCE.validate(cardNumber, ZERO_NUMBERS_CARD_NUMBER_REGEXP)) {
            return false;
        }
        boolean lengthAllowed = false;
        IntRange intRange = allowedLengths;
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            int allowedLength;
            do {
                allowedLength = n2++;
                if (cardNumber.length() != allowedLength) continue;
                lengthAllowed = true;
            } while (allowedLength != n);
        }
        return lengthAllowed && this.validateWithLuhnAlgorithm(cardNumber);
    }

    public final boolean validateSecurityCode(@NotNull String cvc) {
        Intrinsics.checkNotNullParameter((Object)cvc, (String)"cvc");
        return ((CharSequence)cvc).length() == 0 ? false : RegexpValidator.INSTANCE.validate(cvc, CVC_REGEXP);
    }

    public final boolean validateExpirationDate(@NotNull String expiryDate) {
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        if (((CharSequence)expiryDate).length() == 0 || expiryDate.length() != 5) {
            return false;
        }
        int month = 0;
        int year = 0;
        try {
            String string = expiryDate.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            month = Integer.parseInt(string);
            string = expiryDate.substring(3, 5);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            year = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return 1 <= month ? month < 13 : false;
    }

    private final boolean validateWithLuhnAlgorithm(String cardNumber) {
        int sum = 0;
        int value = 0;
        int n = cardNumber.length() - 1;
        if (0 <= n) {
            do {
                boolean shouldBeDoubled;
                int i = n--;
                value = Character.getNumericValue(cardNumber.charAt(i));
                switch (value) {
                    case -2: 
                    case -1: {
                        return false;
                    }
                }
                boolean bl = shouldBeDoubled = (cardNumber.length() - i) % 2 == 0;
                if (shouldBeDoubled) {
                    sum += (value *= 2) > 9 ? 1 + value % 10 : value;
                    continue;
                }
                sum += value;
            } while (0 <= n);
        }
        return sum % 10 == 0;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lru/tinkoff/acquiring/sdk/utils/CardValidator$RegexpValidator;", "", "()V", "validate", "", "string", "", "regexp", "", "core"})
    private static final class RegexpValidator {
        @NotNull
        public static final RegexpValidator INSTANCE = new RegexpValidator();

        private RegexpValidator() {
        }

        public final boolean validate(@NotNull CharSequence string, @NotNull String regexp) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
            Pattern pattern = Pattern.compile(regexp);
            Matcher matcher = pattern.matcher(string);
            return matcher.matches();
        }
    }
}

