/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0010\u0010\u000b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lru/tinkoff/acquiring/sdk/utils/CardValidator;", "", "()V", "CVC_REGEXP", "", "ZERO_NUMBERS_CARD_NUMBER_REGEXP", "allowedLengths", "", "validateExpirationDate", "", "expiryDate", "validateNumber", "cardNumber", "validateSecurityCode", "cvc", "validateWithLuhnAlgorithm", "RegexpValidator", "core"})
public final class CardValidator {
    private static final int[] allowedLengths;
    private static final String ZERO_NUMBERS_CARD_NUMBER_REGEXP = "[0]{1,}";
    private static final String CVC_REGEXP = "^[0-9]{3}$";
    public static final CardValidator INSTANCE;

    public final boolean validateNumber(@Nullable String cardNumber) {
        if (cardNumber == null) {
            return false;
        }
        if (RegexpValidator.INSTANCE.validate(cardNumber, ZERO_NUMBERS_CARD_NUMBER_REGEXP)) {
            return false;
        }
        boolean lengthAllowed = false;
        for (int allowedLength : allowedLengths) {
            if (cardNumber.length() != allowedLength) continue;
            lengthAllowed = true;
        }
        return lengthAllowed && this.validateWithLuhnAlgorithm(cardNumber);
    }

    public final boolean validateSecurityCode(@NotNull String cvc) {
        Intrinsics.checkParameterIsNotNull((Object)cvc, (String)"cvc");
        CharSequence charSequence = cvc;
        boolean bl = false;
        return charSequence.length() == 0 ? false : RegexpValidator.INSTANCE.validate(cvc, CVC_REGEXP);
    }

    public final boolean validateExpirationDate(@NotNull String expiryDate) {
        Intrinsics.checkParameterIsNotNull((Object)expiryDate, (String)"expiryDate");
        CharSequence charSequence = expiryDate;
        boolean bl = false;
        if (charSequence.length() == 0 || expiryDate.length() != 5) {
            return false;
        }
        int month = 0;
        int year = 0;
        try {
            String string = expiryDate;
            int n = 0;
            int n2 = 2;
            boolean bl2 = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            month = Integer.parseInt(string2);
            string = expiryDate;
            n = 3;
            n2 = 5;
            bl2 = false;
            String string3 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            year = Integer.parseInt(string3);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int n = month;
        return 1 <= n && 12 >= n;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean validateWithLuhnAlgorithm(String cardNumber) {
        int sum = 0;
        int value = 0;
        int n = cardNumber.length() - 1;
        boolean bl = false;
        while (n >= 0) {
            boolean shouldBeDoubled;
            void i;
            value = Character.getNumericValue(cardNumber.charAt((int)i));
            if (value == -1 || value == -2) {
                return false;
            }
            boolean bl2 = shouldBeDoubled = (cardNumber.length() - i) % 2 == 0;
            sum = shouldBeDoubled ? (sum += (value *= 2) > 9 ? 1 + value % 10 : value) : (sum += value);
            --i;
        }
        return sum % 10 == 0;
    }

    private CardValidator() {
    }

    static {
        CardValidator cardValidator;
        INSTANCE = cardValidator = new CardValidator();
        allowedLengths = new int[]{13, 14, 15, 16, 17, 18, 19};
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lru/tinkoff/acquiring/sdk/utils/CardValidator$RegexpValidator;", "", "()V", "validate", "", "string", "", "regexp", "", "core"})
    private static final class RegexpValidator {
        public static final RegexpValidator INSTANCE;

        public final boolean validate(@NotNull CharSequence string, @NotNull String regexp) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
            Intrinsics.checkParameterIsNotNull((Object)regexp, (String)"regexp");
            Pattern pattern = Pattern.compile(regexp);
            Matcher matcher = pattern.matcher(string);
            return matcher.matches();
        }

        private RegexpValidator() {
        }

        static {
            RegexpValidator regexpValidator;
            INSTANCE = regexpValidator = new RegexpValidator();
        }
    }
}

