/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.requests;

import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.acquiring.sdk.AcquiringSdk;
import ru.tinkoff.acquiring.sdk.network.NetworkClient;
import ru.tinkoff.acquiring.sdk.responses.AcquiringResponse;
import ru.tinkoff.acquiring.sdk.utils.Request;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 >*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001>B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020'0&H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u001c\u0010*\u001a\u00020\u00052\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020'0,H\u0004J\b\u0010-\u001a\u00020\u0005H\u0016J\b\u0010.\u001a\u00020\fH\u0016J\u001c\u0010/\u001a\u00020\u00052\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020'0,H\u0014JZ\u00100\u001a\u00020)\"\b\b\u0001\u0010\u0001*\u00020\u00022\f\u00101\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00002\f\u00102\u001a\b\u0012\u0004\u0012\u0002H\u0001032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020)052\u0016\u00106\u001a\u0012\u0012\b\u0012\u000607j\u0002`8\u0012\u0004\u0012\u00020)05H\u0004J\b\u00109\u001a\u00020)H$J*\u0010:\u001a\u00020)*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020'0&2\u0006\u0010;\u001a\u00020\u00052\b\u0010<\u001a\u0004\u0018\u00010'H\u0004J\u0016\u00109\u001a\u00020)*\u0004\u0018\u00010'2\u0006\u0010=\u001a\u00020\u0005H\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0014j\b\u0012\u0004\u0012\u00020\u0005`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\b\"\u0004\b\u0018\u0010\u0006R\u001a\u0010\u0019\u001a\u00020\u001aX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0005X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\b\"\u0004\b!\u0010\u0006R$\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0014j\b\u0012\u0004\u0012\u00020\u0005`\u00158PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006?"}, d2={"Lru/tinkoff/acquiring/sdk/requests/AcquiringRequest;", "R", "Lru/tinkoff/acquiring/sdk/responses/AcquiringResponse;", "Lru/tinkoff/acquiring/sdk/utils/Request;", "apiMethod", "", "(Ljava/lang/String;)V", "getApiMethod$core", "()Ljava/lang/String;", "contentType", "getContentType", "disposed", "", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "httpRequestMethod", "getHttpRequestMethod", "ignoredFieldsSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "password", "getPassword", "setPassword", "publicKey", "Ljava/security/PublicKey;", "getPublicKey$core", "()Ljava/security/PublicKey;", "setPublicKey$core", "(Ljava/security/PublicKey;)V", "terminalKey", "getTerminalKey$core", "setTerminalKey$core", "tokenIgnoreFields", "getTokenIgnoreFields$core", "()Ljava/util/HashSet;", "asMap", "", "", "dispose", "", "encodeRequestBody", "params", "", "getRequestBody", "isDisposed", "jsonRequestBody", "performRequest", "request", "responseClass", "Ljava/lang/Class;", "onSuccess", "Lkotlin/Function1;", "onFailure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "validate", "putIfNotNull", "key", "value", "fieldName", "Companion", "core"})
public abstract class AcquiringRequest<R extends AcquiringResponse>
implements Request<R> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String apiMethod;
    @NotNull
    private final Gson gson;
    @NotNull
    private final String httpRequestMethod;
    @NotNull
    private final String contentType;
    public String terminalKey;
    public PublicKey publicKey;
    private volatile boolean disposed;
    @NotNull
    private final HashSet<String> ignoredFieldsSet;
    @Nullable
    private String password;
    @NotNull
    public static final String TERMINAL_KEY = "TerminalKey";
    @NotNull
    public static final String PASSWORD = "Password";
    @NotNull
    public static final String TOKEN = "Token";
    @NotNull
    public static final String PAYMENT_ID = "PaymentId";
    @NotNull
    public static final String SEND_EMAIL = "SendEmail";
    @NotNull
    public static final String EMAIL = "InfoEmail";
    @NotNull
    public static final String CARD_DATA = "CardData";
    @NotNull
    public static final String LANGUAGE = "Language";
    @NotNull
    public static final String AMOUNT = "Amount";
    @NotNull
    public static final String ORDER_ID = "OrderId";
    @NotNull
    public static final String DESCRIPTION = "Description";
    @NotNull
    public static final String PAY_FORM = "PayForm";
    @NotNull
    public static final String CUSTOMER_KEY = "CustomerKey";
    @NotNull
    public static final String RECURRENT = "Recurrent";
    @NotNull
    public static final String REBILL_ID = "RebillId";
    @NotNull
    public static final String CARD_ID = "CardId";
    @NotNull
    public static final String CVV = "CVV";
    @NotNull
    public static final String PAY_TYPE = "PayType";
    @NotNull
    public static final String RECEIPT = "Receipt";
    @NotNull
    public static final String RECEIPTS = "Receipts";
    @NotNull
    public static final String SHOPS = "Shops";
    @NotNull
    public static final String DATA = "DATA";
    @NotNull
    public static final String CHARGE_FLAG = "chargeFlag";
    @NotNull
    public static final String DATA_KEY_EMAIL = "Email";
    @NotNull
    public static final String CHECK_TYPE = "CheckType";
    @NotNull
    public static final String REQUEST_KEY = "RequestKey";
    @NotNull
    public static final String SOURCE = "Source";
    @NotNull
    public static final String PAYMENT_SOURCE = "PaymentSource";
    @NotNull
    public static final String ANDROID_PAY_TOKEN = "EncryptedPaymentData";
    @NotNull
    public static final String DATA_TYPE = "DataType";
    @NotNull
    public static final String REDIRECT_DUE_DATE = "RedirectDueDate";
    @NotNull
    public static final String NOTIFICATION_URL = "NotificationURL";
    @NotNull
    public static final String IP = "IP";
    @NotNull
    public static final String CONNECTION_TYPE = "connection_type";
    @NotNull
    public static final String SDK_VERSION = "sdk_version";
    @NotNull
    public static final String THREE_DS_SERVER_TRANS_ID = "threeDSServerTransID";
    @NotNull
    public static final String TRANS_STATUS = "transStatus";
    @NotNull
    public static final String CRES = "cres";

    public AcquiringRequest(@NotNull String apiMethod) {
        Intrinsics.checkNotNullParameter((Object)apiMethod, (String)"apiMethod");
        this.apiMethod = apiMethod;
        this.gson = NetworkClient.Companion.createGson();
        this.httpRequestMethod = "POST";
        this.contentType = "application/json";
        Object[] objectArray = new String[]{DATA, RECEIPT, RECEIPTS, SHOPS};
        this.ignoredFieldsSet = SetsKt.hashSetOf((Object[])objectArray);
    }

    @NotNull
    public final String getApiMethod$core() {
        return this.apiMethod;
    }

    @NotNull
    protected final Gson getGson() {
        return this.gson;
    }

    @NotNull
    public String getHttpRequestMethod() {
        return this.httpRequestMethod;
    }

    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    @NotNull
    public final String getTerminalKey$core() {
        String string = this.terminalKey;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"terminalKey");
        return null;
    }

    public final void setTerminalKey$core(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.terminalKey = string;
    }

    @NotNull
    public final PublicKey getPublicKey$core() {
        PublicKey publicKey = this.publicKey;
        if (publicKey != null) {
            return publicKey;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"publicKey");
        return null;
    }

    public final void setPublicKey$core(@NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"<set-?>");
        this.publicKey = publicKey;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(@Nullable String string) {
        this.password = string;
    }

    @NotNull
    public HashSet<String> getTokenIgnoreFields$core() {
        return this.ignoredFieldsSet;
    }

    protected abstract void validate();

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @NotNull
    public Map<String, Object> asMap() {
        HashMap map = new HashMap();
        this.putIfNotNull(map, TERMINAL_KEY, this.getTerminalKey$core());
        this.putIfNotNull(map, PASSWORD, this.password);
        return map;
    }

    protected final <R extends AcquiringResponse> void performRequest(@NotNull AcquiringRequest<R> request, @NotNull Class<R> responseClass, @NotNull Function1<? super R, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailure) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        request.validate();
        NetworkClient client = new NetworkClient();
        client.call$core(request, responseClass, onSuccess, onFailure);
    }

    protected final void putIfNotNull(@NotNull Map<String, Object> $this$putIfNotNull, @NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter($this$putIfNotNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value == null) {
            return;
        }
        $this$putIfNotNull.put(key, value);
    }

    protected final void validate(@Nullable Object $this$validate, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        if ($this$validate == null) {
            boolean bl = false;
            String string = "Unable to build request: field '" + fieldName + "' is null";
            throw new IllegalStateException(string.toString());
        }
        Object object = $this$validate;
        if (object instanceof String) {
            if (!(((CharSequence)$this$validate).length() > 0)) {
                boolean $i$a$-check-AcquiringRequest$validate$42 = false;
                String $i$a$-check-AcquiringRequest$validate$42 = "Unable to build request: field '" + fieldName + "' is empty";
                throw new IllegalStateException($i$a$-check-AcquiringRequest$validate$42.toString());
            }
        } else if (object instanceof Long && !(((Number)$this$validate).longValue() >= 0L)) {
            boolean bl = false;
            String string = "Unable to build request: field '" + fieldName + "' is negative";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public String getRequestBody() {
        Map<String, Object> params = this.asMap();
        if (params.isEmpty()) {
            return "";
        }
        return Intrinsics.areEqual((Object)this.getContentType(), (Object)"application/x-www-form-urlencoded") ? this.encodeRequestBody(params) : this.jsonRequestBody(params);
    }

    @NotNull
    protected String jsonRequestBody(@NotNull Map<String, ? extends Object> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        String string = this.gson.toJson(params);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(params)");
        return string;
    }

    @NotNull
    protected final String encodeRequestBody(@NotNull Map<String, ? extends Object> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, ? extends Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value1 = entry.getValue();
            try {
                String value = URLEncoder.encode(value1.toString(), "UTF-8");
                builder.append(key);
                builder.append('=');
                builder.append(value);
                builder.append('&');
            }
            catch (UnsupportedEncodingException e) {
                AcquiringSdk.AsdkLogger.log(e);
            }
        }
        builder.setLength(builder.length() - 1);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b&\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lru/tinkoff/acquiring/sdk/requests/AcquiringRequest$Companion;", "", "()V", "AMOUNT", "", "ANDROID_PAY_TOKEN", "CARD_DATA", "CARD_ID", "CHARGE_FLAG", "CHECK_TYPE", "CONNECTION_TYPE", "CRES", "CUSTOMER_KEY", "CVV", "DATA", "DATA_KEY_EMAIL", "DATA_TYPE", "DESCRIPTION", "EMAIL", "IP", "LANGUAGE", "NOTIFICATION_URL", "ORDER_ID", "PASSWORD", "PAYMENT_ID", "PAYMENT_SOURCE", "PAY_FORM", "PAY_TYPE", "REBILL_ID", "RECEIPT", "RECEIPTS", "RECURRENT", "REDIRECT_DUE_DATE", "REQUEST_KEY", "SDK_VERSION", "SEND_EMAIL", "SHOPS", "SOURCE", "TERMINAL_KEY", "THREE_DS_SERVER_TRANS_ID", "TOKEN", "TRANS_STATUS", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

