/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.models;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.acquiring.sdk.models.AgentData;
import ru.tinkoff.acquiring.sdk.models.SupplierInfo;
import ru.tinkoff.acquiring.sdk.models.enums.PaymentMethod;
import ru.tinkoff.acquiring.sdk.models.enums.PaymentObject;
import ru.tinkoff.acquiring.sdk.models.enums.Tax;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 C2\u00020\u0001:\u0001CB9\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB\u0005\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u00020@2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020@0A\u00a2\u0006\u0002\bBJ\u001f\u00106\u001a\u00020@2\u0017\u00106\u001a\u0013\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020@0A\u00a2\u0006\u0002\bBR \u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u0018\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR \u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001a\"\u0004\b\u001e\u0010\u001cR \u0010\u001f\u001a\u0004\u0018\u00010 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R \u0010%\u001a\u0004\u0018\u00010&8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R \u00103\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u001a\"\u0004\b5\u0010\u001cR \u00106\u001a\u0004\u0018\u0001078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R \u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?\u00a8\u0006D"}, d2={"Lru/tinkoff/acquiring/sdk/models/Item;", "Ljava/io/Serializable;", "name", "", "price", "", "quantity", "", "amount", "tax", "Lru/tinkoff/acquiring/sdk/models/enums/Tax;", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Double;Ljava/lang/Long;Lru/tinkoff/acquiring/sdk/models/enums/Tax;)V", "()V", "agentData", "Lru/tinkoff/acquiring/sdk/models/AgentData;", "getAgentData", "()Lru/tinkoff/acquiring/sdk/models/AgentData;", "setAgentData", "(Lru/tinkoff/acquiring/sdk/models/AgentData;)V", "getAmount", "()Ljava/lang/Long;", "setAmount", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "ean13", "getEan13", "()Ljava/lang/String;", "setEan13", "(Ljava/lang/String;)V", "getName", "setName", "paymentMethod", "Lru/tinkoff/acquiring/sdk/models/enums/PaymentMethod;", "getPaymentMethod", "()Lru/tinkoff/acquiring/sdk/models/enums/PaymentMethod;", "setPaymentMethod", "(Lru/tinkoff/acquiring/sdk/models/enums/PaymentMethod;)V", "paymentObject", "Lru/tinkoff/acquiring/sdk/models/enums/PaymentObject;", "getPaymentObject", "()Lru/tinkoff/acquiring/sdk/models/enums/PaymentObject;", "setPaymentObject", "(Lru/tinkoff/acquiring/sdk/models/enums/PaymentObject;)V", "getPrice", "()J", "setPrice", "(J)V", "getQuantity", "()D", "setQuantity", "(D)V", "shopCode", "getShopCode", "setShopCode", "supplierInfo", "Lru/tinkoff/acquiring/sdk/models/SupplierInfo;", "getSupplierInfo", "()Lru/tinkoff/acquiring/sdk/models/SupplierInfo;", "setSupplierInfo", "(Lru/tinkoff/acquiring/sdk/models/SupplierInfo;)V", "getTax", "()Lru/tinkoff/acquiring/sdk/models/enums/Tax;", "setTax", "(Lru/tinkoff/acquiring/sdk/models/enums/Tax;)V", "", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Companion", "core"})
public final class Item
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @SerializedName(value="Price")
    private long price;
    @SerializedName(value="Quantity")
    private double quantity;
    @SerializedName(value="Name")
    @Nullable
    private String name;
    @SerializedName(value="Amount")
    @Nullable
    private Long amount;
    @SerializedName(value="Tax")
    @Nullable
    private Tax tax;
    @SerializedName(value="Ean13")
    @Nullable
    private String ean13;
    @SerializedName(value="ShopCode")
    @Nullable
    private String shopCode;
    @SerializedName(value="PaymentMethod")
    @Nullable
    private PaymentMethod paymentMethod;
    @SerializedName(value="PaymentObject")
    @Nullable
    private PaymentObject paymentObject;
    @SerializedName(value="AgentData")
    @Nullable
    private AgentData agentData;
    @SerializedName(value="SupplierInfo")
    @Nullable
    private SupplierInfo supplierInfo;
    private static final int QUANTITY_SCALE_FACTOR = 3;

    public Item() {
        this.quantity = Item.Companion.round(this.quantity, 3);
    }

    public final long getPrice() {
        return this.price;
    }

    public final void setPrice(long l) {
        this.price = l;
    }

    public final double getQuantity() {
        return this.quantity;
    }

    public final void setQuantity(double d) {
        this.quantity = d;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    @Nullable
    public final Long getAmount() {
        return this.amount;
    }

    public final void setAmount(@Nullable Long l) {
        this.amount = l;
    }

    @Nullable
    public final Tax getTax() {
        return this.tax;
    }

    public final void setTax(@Nullable Tax tax) {
        this.tax = tax;
    }

    @Nullable
    public final String getEan13() {
        return this.ean13;
    }

    public final void setEan13(@Nullable String string) {
        this.ean13 = string;
    }

    @Nullable
    public final String getShopCode() {
        return this.shopCode;
    }

    public final void setShopCode(@Nullable String string) {
        this.shopCode = string;
    }

    @Nullable
    public final PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public final void setPaymentMethod(@Nullable PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @Nullable
    public final PaymentObject getPaymentObject() {
        return this.paymentObject;
    }

    public final void setPaymentObject(@Nullable PaymentObject paymentObject) {
        this.paymentObject = paymentObject;
    }

    @Nullable
    public final AgentData getAgentData() {
        return this.agentData;
    }

    public final void setAgentData(@Nullable AgentData agentData) {
        this.agentData = agentData;
    }

    @Nullable
    public final SupplierInfo getSupplierInfo() {
        return this.supplierInfo;
    }

    public final void setSupplierInfo(@Nullable SupplierInfo supplierInfo) {
        this.supplierInfo = supplierInfo;
    }

    public Item(@Nullable String name, @Nullable Long price, @Nullable Double quantity, @Nullable Long amount, @Nullable Tax tax) {
        this();
        this.name = name;
        Long l = price;
        this.price = l == null ? 0L : l;
        Double d = quantity;
        this.quantity = Item.Companion.round(d == null ? 0.0 : d, 3);
        this.amount = amount;
        this.tax = tax;
    }

    public final void agentData(@NotNull Function1<? super AgentData, Unit> agentData) {
        Intrinsics.checkNotNullParameter(agentData, (String)"agentData");
        AgentData agentData2 = new AgentData();
        agentData.invoke((Object)agentData2);
        this.agentData = agentData2;
    }

    public final void supplierInfo(@NotNull Function1<? super SupplierInfo, Unit> supplierInfo) {
        Intrinsics.checkNotNullParameter(supplierInfo, (String)"supplierInfo");
        SupplierInfo supplierInfo2 = new SupplierInfo();
        supplierInfo.invoke((Object)supplierInfo2);
        this.supplierInfo = supplierInfo2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lru/tinkoff/acquiring/sdk/models/Item$Companion;", "", "()V", "QUANTITY_SCALE_FACTOR", "", "round", "", "value", "scale", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final double round(double value, int scale) {
            return (double)MathKt.roundToInt((double)(value * Math.pow(10.0, scale))) / Math.pow(10.0, scale);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

