/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.network;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.acquiring.sdk.AcquiringSdk;
import ru.tinkoff.acquiring.sdk.exceptions.AcquiringApiException;
import ru.tinkoff.acquiring.sdk.exceptions.NetworkException;
import ru.tinkoff.acquiring.sdk.models.enums.CardStatus;
import ru.tinkoff.acquiring.sdk.models.enums.ResponseStatus;
import ru.tinkoff.acquiring.sdk.models.enums.Tax;
import ru.tinkoff.acquiring.sdk.models.enums.Taxation;
import ru.tinkoff.acquiring.sdk.network.AcquiringApi;
import ru.tinkoff.acquiring.sdk.requests.AcquiringRequest;
import ru.tinkoff.acquiring.sdk.requests.FinishAuthorizeRequest;
import ru.tinkoff.acquiring.sdk.responses.AcquiringResponse;
import ru.tinkoff.acquiring.sdk.responses.GetCardListResponse;
import ru.tinkoff.acquiring.sdk.utils.serialization.CardStatusSerializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.CardsListDeserializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.PaymentStatusSerializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.SerializableExclusionStrategy;
import ru.tinkoff.acquiring.sdk.utils.serialization.TaxSerializer;
import ru.tinkoff.acquiring.sdk.utils.serialization.TaxationSerializer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J_\u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000e2\u0016\u0010\u000f\u001a\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00060\u000eH\u0000\u00a2\u0006\u0002\b\u0012JB\u0010\u0013\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\u0014\u001a\u0002H\u00072!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00060\u000eH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J4\u0010\u001e\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00060\u000eH\u0002J4\u0010!\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lru/tinkoff/acquiring/sdk/network/NetworkClient;", "", "()V", "gson", "Lcom/google/gson/Gson;", "call", "", "R", "Lru/tinkoff/acquiring/sdk/responses/AcquiringResponse;", "request", "Lru/tinkoff/acquiring/sdk/requests/AcquiringRequest;", "responseClass", "Ljava/lang/Class;", "onSuccess", "Lkotlin/Function1;", "onFailure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "call$core", "checkResult", "result", "onChecked", "", "Lkotlin/ParameterName;", "name", "isSuccess", "(Lru/tinkoff/acquiring/sdk/responses/AcquiringResponse;Lkotlin/jvm/functions/Function1;)V", "closeQuietly", "closeable", "Ljava/io/Closeable;", "prepareBody", "onReady", "", "prepareConnection", "Ljava/net/HttpURLConnection;", "prepareURL", "Ljava/net/URL;", "apiMethod", "", "read", "reader", "Ljava/io/InputStreamReader;", "Companion", "core"})
public final class NetworkClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Gson gson = Companion.createGson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R extends AcquiringResponse> void call$core(@NotNull AcquiringRequest<R> request, @NotNull Class<R> responseClass, @NotNull Function1<? super R, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailure) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        AcquiringResponse result = null;
        String response = null;
        InputStreamReader responseReader = null;
        Ref.ObjectRef requestContentStream = new Ref.ObjectRef();
        try {
            HttpURLConnection httpURLConnection;
            Ref.ObjectRef connection = new Ref.ObjectRef();
            String string = request.getHttpRequestMethod();
            if (Intrinsics.areEqual((Object)string, (Object)"GET")) {
                this.prepareConnection(request, (Function1<? super HttpURLConnection, Unit>)((Function1)new Function1<HttpURLConnection, Unit>((Ref.ObjectRef<HttpURLConnection>)connection, request){
                    final /* synthetic */ Ref.ObjectRef<HttpURLConnection> $connection;
                    final /* synthetic */ AcquiringRequest<R> $request;
                    {
                        this.$connection = $connection;
                        this.$request = $request;
                        super(1);
                    }

                    public final void invoke(@NotNull HttpURLConnection it) {
                        HttpURLConnection httpURLConnection;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$connection.element = it;
                        StringBuilder stringBuilder = new StringBuilder().append("=== Sending ").append(this.$request.getHttpRequestMethod()).append(" request to ");
                        if (this.$connection.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                            httpURLConnection = null;
                        } else {
                            httpURLConnection = (HttpURLConnection)this.$connection.element;
                        }
                        AcquiringSdk.Companion.log(stringBuilder.append(httpURLConnection.getURL()).toString());
                    }
                }));
            } else if (Intrinsics.areEqual((Object)string, (Object)"POST")) {
                this.prepareBody(request, (Function1<? super byte[], Unit>)((Function1)new Function1<byte[], Unit>(this, request, (Ref.ObjectRef<HttpURLConnection>)connection, (Ref.ObjectRef<OutputStream>)requestContentStream){
                    final /* synthetic */ NetworkClient this$0;
                    final /* synthetic */ AcquiringRequest<R> $request;
                    final /* synthetic */ Ref.ObjectRef<HttpURLConnection> $connection;
                    final /* synthetic */ Ref.ObjectRef<OutputStream> $requestContentStream;
                    {
                        this.this$0 = $receiver;
                        this.$request = $request;
                        this.$connection = $connection;
                        this.$requestContentStream = $requestContentStream;
                        super(1);
                    }

                    public final void invoke(@NotNull byte[] body) {
                        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                        NetworkClient.access$prepareConnection(this.this$0, this.$request, (Function1)new Function1<HttpURLConnection, Unit>(this.$connection, body, this.$requestContentStream, this.$request){
                            final /* synthetic */ Ref.ObjectRef<HttpURLConnection> $connection;
                            final /* synthetic */ byte[] $body;
                            final /* synthetic */ Ref.ObjectRef<OutputStream> $requestContentStream;
                            final /* synthetic */ AcquiringRequest<R> $request;
                            {
                                this.$connection = $connection;
                                this.$body = $body;
                                this.$requestContentStream = $requestContentStream;
                                this.$request = $request;
                                super(1);
                            }

                            public final void invoke(@NotNull HttpURLConnection it) {
                                HttpURLConnection httpURLConnection;
                                HttpURLConnection httpURLConnection2;
                                HttpURLConnection httpURLConnection3;
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                this.$connection.element = it;
                                if (this.$connection.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                                    httpURLConnection3 = null;
                                } else {
                                    httpURLConnection3 = (HttpURLConnection)this.$connection.element;
                                }
                                httpURLConnection3.setRequestProperty("Content-length", String.valueOf(this.$body.length));
                                if (this.$connection.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                                    httpURLConnection2 = null;
                                } else {
                                    httpURLConnection2 = (HttpURLConnection)this.$connection.element;
                                }
                                this.$requestContentStream.element = httpURLConnection2.getOutputStream();
                                OutputStream outputStream = (OutputStream)this.$requestContentStream.element;
                                if (outputStream != null) {
                                    outputStream.write(this.$body);
                                }
                                StringBuilder stringBuilder = new StringBuilder().append("=== Sending ").append(this.$request.getHttpRequestMethod()).append(" request to ");
                                if (this.$connection.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                                    httpURLConnection = null;
                                } else {
                                    httpURLConnection = (HttpURLConnection)this.$connection.element;
                                }
                                AcquiringSdk.Companion.log(stringBuilder.append(httpURLConnection.getURL()).toString());
                            }
                        });
                    }
                }));
            }
            if (connection.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                httpURLConnection = null;
            } else {
                httpURLConnection = (HttpURLConnection)connection.element;
            }
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode == 200) {
                HttpURLConnection httpURLConnection2;
                if (connection.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                    httpURLConnection2 = null;
                } else {
                    httpURLConnection2 = (HttpURLConnection)connection.element;
                }
                responseReader = new InputStreamReader(httpURLConnection2.getInputStream());
                response = this.read(responseReader);
                AcquiringSdk.Companion.log(Intrinsics.stringPlus((String)"=== Got server response: ", (Object)response));
                Object object = this.gson.fromJson(response, responseClass);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(response, responseClass)");
                result = (AcquiringResponse)object;
                this.checkResult(result, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(request, onSuccess, result, onFailure){
                    final /* synthetic */ AcquiringRequest<R> $request;
                    final /* synthetic */ Function1<R, Unit> $onSuccess;
                    final /* synthetic */ R $result;
                    final /* synthetic */ Function1<Exception, Unit> $onFailure;
                    {
                        this.$request = $request;
                        this.$onSuccess = $onSuccess;
                        this.$result = $result;
                        this.$onFailure = $onFailure;
                        super(1);
                    }

                    public final void invoke(boolean isSuccess) {
                        if (!this.$request.isDisposed()) {
                            if (isSuccess) {
                                AcquiringSdk.Companion.log("=== Request done with success, sent for processing");
                                this.$onSuccess.invoke(this.$result);
                            } else {
                                AcquiringSdk.Companion.log("=== Request done with fail");
                                StringBuilder stringBuilder = new StringBuilder();
                                String string = ((AcquiringResponse)this.$result).getMessage();
                                if (string == null) {
                                    string = "";
                                }
                                StringBuilder stringBuilder2 = stringBuilder.append(string).append(' ');
                                String string2 = ((AcquiringResponse)this.$result).getDetails();
                                if (string2 == null) {
                                    string2 = "";
                                }
                                this.$onFailure.invoke((Object)new AcquiringApiException((AcquiringResponse)this.$result, stringBuilder2.append(string2).toString()));
                            }
                        }
                    }
                }));
            } else {
                HttpURLConnection httpURLConnection3;
                if (connection.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                    httpURLConnection3 = null;
                } else {
                    httpURLConnection3 = (HttpURLConnection)connection.element;
                }
                responseReader = new InputStreamReader(httpURLConnection3.getErrorStream());
                response = this.read(responseReader);
                if (((CharSequence)response).length() > 0) {
                    AcquiringSdk.Companion.log(Intrinsics.stringPlus((String)"=== Got server error response: ", (Object)response));
                } else {
                    AcquiringSdk.Companion.log(Intrinsics.stringPlus((String)"=== Got server error response code: ", (Object)responseCode));
                }
                if (!request.isDisposed()) {
                    onFailure.invoke((Object)new NetworkException(Intrinsics.stringPlus((String)"Unable to performRequest request ", (Object)request.getApiMethod$core())));
                }
            }
        }
        catch (IOException e) {
            if (!request.isDisposed()) {
                onFailure.invoke((Object)new NetworkException(Intrinsics.stringPlus((String)"Unable to performRequest request ", (Object)request.getApiMethod$core()), e));
            }
        }
        catch (JsonParseException e) {
            if (!request.isDisposed()) {
                onFailure.invoke((Object)new AcquiringApiException(Intrinsics.stringPlus((String)"Invalid response. ", response), e));
            }
        }
        finally {
            this.closeQuietly(responseReader);
            this.closeQuietly((Closeable)requestContentStream.element);
        }
    }

    private final <R extends AcquiringResponse> void prepareConnection(AcquiringRequest<R> request, Function1<? super HttpURLConnection, Unit> onReady) {
        HttpURLConnection connection;
        URL targetUrl = this.prepareURL(request.getApiMethod$core());
        URLConnection uRLConnection = targetUrl.openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection $this$prepareConnection_u24lambda_u2d0 = connection = (HttpURLConnection)uRLConnection;
        boolean bl = false;
        $this$prepareConnection_u24lambda_u2d0.setRequestMethod(request.getHttpRequestMethod());
        $this$prepareConnection_u24lambda_u2d0.setConnectTimeout(40000);
        $this$prepareConnection_u24lambda_u2d0.setReadTimeout(40000);
        $this$prepareConnection_u24lambda_u2d0.setDoOutput(!Intrinsics.areEqual((Object)request.getHttpRequestMethod(), (Object)"GET"));
        $this$prepareConnection_u24lambda_u2d0.setRequestProperty("Content-type", request.getContentType());
        if (request instanceof FinishAuthorizeRequest && ((FinishAuthorizeRequest)request).is3DsVersionV2()) {
            $this$prepareConnection_u24lambda_u2d0.setRequestProperty("User-Agent", System.getProperty("http.agent"));
            $this$prepareConnection_u24lambda_u2d0.setRequestProperty("Accept", "application/json");
        }
        onReady.invoke((Object)connection);
    }

    private final <R extends AcquiringResponse> void prepareBody(AcquiringRequest<R> request, Function1<? super byte[], Unit> onReady) {
        String requestBody = request.getRequestBody();
        AcquiringSdk.Companion.log(Intrinsics.stringPlus((String)"=== Parameters: ", (Object)requestBody));
        String string = requestBody;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        onReady.invoke((Object)byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final <R extends AcquiringResponse> void checkResult(R result, Function1<? super Boolean, Unit> onChecked) {
        if (Intrinsics.areEqual((Object)result.getErrorCode(), (Object)"0")) {
            Boolean bl = result.isSuccess();
            Intrinsics.checkNotNull((Object)bl);
            if (bl.booleanValue()) {
                onChecked.invoke((Object)true);
                return;
            }
        }
        onChecked.invoke((Object)false);
    }

    private final URL prepareURL(String apiMethod) throws MalformedURLException {
        CharSequence charSequence = apiMethod;
        if (charSequence == null || charSequence.length() == 0) {
            throw new IllegalArgumentException("Cannot prepare URL for request api method is empty or null!");
        }
        StringBuilder builder = new StringBuilder(AcquiringApi.INSTANCE.getUrl(apiMethod));
        builder.append("/");
        builder.append(apiMethod);
        return new URL(builder.toString());
    }

    private final String read(InputStreamReader reader) throws IOException {
        char[] buffer = new char[4096];
        Ref.IntRef read = new Ref.IntRef();
        read.element = -1;
        StringBuilder result = new StringBuilder();
        while (NetworkClient.read$lambda-1(read, reader, buffer) != -1) {
            result.append(buffer, 0, read.element);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            AcquiringSdk.Companion.log(e);
        }
    }

    private static final int read$lambda-1(Ref.IntRef $read, InputStreamReader $reader, char[] $buffer) {
        $read.element = $reader.read($buffer, 0, 4096);
        return $read.element;
    }

    public static final /* synthetic */ void access$prepareConnection(NetworkClient $this, AcquiringRequest request, Function1 onReady) {
        $this.prepareConnection(request, (Function1<? super HttpURLConnection, Unit>)onReady);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lru/tinkoff/acquiring/sdk/network/NetworkClient$Companion;", "", "()V", "createGson", "Lcom/google/gson/Gson;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson createGson() {
            Object[] objectArray = new int[]{128, 8};
            GsonBuilder gsonBuilder = new GsonBuilder().excludeFieldsWithModifiers(objectArray);
            objectArray = new ExclusionStrategy[1];
            objectArray[0] = (int)new SerializableExclusionStrategy();
            Gson gson = gsonBuilder.setExclusionStrategies((ExclusionStrategy[])objectArray).registerTypeAdapter((Type)((Object)CardStatus.class), (Object)new CardStatusSerializer()).registerTypeAdapter((Type)((Object)ResponseStatus.class), (Object)new PaymentStatusSerializer()).registerTypeAdapter((Type)((Object)GetCardListResponse.class), (Object)new CardsListDeserializer()).registerTypeAdapter((Type)((Object)Tax.class), (Object)new TaxSerializer()).registerTypeAdapter((Type)((Object)Taxation.class), (Object)new TaxationSerializer()).create();
            Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder()\n          \u2026                .create()");
            return gson;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

