/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.models.paysources;

import java.security.PublicKey;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.acquiring.sdk.models.paysources.CardSource;
import ru.tinkoff.acquiring.sdk.utils.CardValidator;
import ru.tinkoff.acquiring.sdk.utils.CryptoUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005B\u0011\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0007R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u0007R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lru/tinkoff/acquiring/sdk/models/paysources/AttachedCard;", "Lru/tinkoff/acquiring/sdk/models/paysources/CardSource;", "cardId", "", "cvc", "(Ljava/lang/String;Ljava/lang/String;)V", "rebillId", "(Ljava/lang/String;)V", "()V", "getCardId", "()Ljava/lang/String;", "setCardId", "getCvc", "setCvc", "getRebillId", "setRebillId", "encode", "publicKey", "Ljava/security/PublicKey;", "validate", "", "Companion", "core"})
public final class AttachedCard
implements CardSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String cardId;
    @Nullable
    private String cvc;
    @Nullable
    private String rebillId;
    @NotNull
    private static final String KEY_CARD_ID = "CardId";
    @NotNull
    private static final String KEY_CVC = "CVC";

    public AttachedCard() {
    }

    @Nullable
    public final String getCardId() {
        return this.cardId;
    }

    public final void setCardId(@Nullable String string) {
        this.cardId = string;
    }

    @Nullable
    public final String getCvc() {
        return this.cvc;
    }

    public final void setCvc(@Nullable String string) {
        this.cvc = string;
    }

    @Nullable
    public final String getRebillId() {
        return this.rebillId;
    }

    public final void setRebillId(@Nullable String string) {
        this.rebillId = string;
    }

    public AttachedCard(@Nullable String cardId, @Nullable String cvc) {
        this();
        this.cardId = cardId;
        this.cvc = cvc;
    }

    public AttachedCard(@Nullable String rebillId) {
        this();
        this.rebillId = rebillId;
    }

    @Override
    @NotNull
    public String encode(@NotNull PublicKey publicKey) {
        String string;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.validate();
        CharSequence charSequence = this.rebillId;
        if (charSequence == null || charSequence.length() == 0) {
            String string2 = "%s=%s;%s=%s";
            Object[] objectArray = new Object[]{KEY_CARD_ID, this.cardId, KEY_CVC, this.cvc};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            String mergedData = string3;
            string = CryptoUtils.INSTANCE.encodeBase64(CryptoUtils.INSTANCE.encryptRsa(mergedData, publicKey));
        } else {
            String string4 = this.rebillId;
            Intrinsics.checkNotNull((Object)string4);
            string = CryptoUtils.INSTANCE.encodeBase64(CryptoUtils.INSTANCE.encryptRsa(string4, publicKey));
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate() {
        CharSequence charSequence = this.rebillId;
        if (charSequence == null || charSequence.length() == 0) {
            charSequence = this.cardId;
            if (!(!(charSequence == null || charSequence.length() == 0))) {
                boolean $i$a$-check-AttachedCard$validate$42 = false;
                String $i$a$-check-AttachedCard$validate$42 = "CardId should not be empty ";
                throw new IllegalStateException($i$a$-check-AttachedCard$validate$42.toString());
            }
            charSequence = this.cvc;
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string = this.cvc;
                Intrinsics.checkNotNull((Object)string);
                if (CardValidator.INSTANCE.validateSecurityCode(string)) {
                    return;
                }
            }
            boolean bl = false;
            if (bl) return;
            boolean $i$a$-check-AttachedCard$validate$52 = false;
            String $i$a$-check-AttachedCard$validate$52 = "Field security code should not be empty ";
            throw new IllegalStateException($i$a$-check-AttachedCard$validate$52.toString());
        }
        String string = this.rebillId;
        Intrinsics.checkNotNull((Object)string);
        if (((CharSequence)string).length() > 0) {
            return;
        }
        boolean bl = false;
        if (bl) return;
        boolean bl2 = false;
        String string2 = "RebillId should not be empty ";
        throw new IllegalStateException(string2.toString());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lru/tinkoff/acquiring/sdk/models/paysources/AttachedCard$Companion;", "", "()V", "KEY_CARD_ID", "", "KEY_CVC", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

