/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.acquiring.sdk.models.paysources;

import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.acquiring.sdk.models.paysources.CardSource;
import ru.tinkoff.acquiring.sdk.utils.CardValidator;
import ru.tinkoff.acquiring.sdk.utils.CryptoUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005B\u0011\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\r\u0010\u0010\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0007R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u0007R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lru/tinkoff/acquiring/sdk/models/paysources/AttachedCard;", "Lru/tinkoff/acquiring/sdk/models/paysources/CardSource;", "cardId", "", "cvc", "(Ljava/lang/String;Ljava/lang/String;)V", "rebillId", "(Ljava/lang/String;)V", "()V", "getCardId", "()Ljava/lang/String;", "setCardId", "getCvc", "setCvc", "getRebillId", "setRebillId", "buildStringForEncoding", "buildStringForEncoding$core", "encode", "publicKey", "Ljava/security/PublicKey;", "validate", "", "core"})
public final class AttachedCard
implements CardSource {
    @Nullable
    private String cardId;
    @Nullable
    private String cvc;
    @Nullable
    private String rebillId;

    public AttachedCard() {
    }

    @Nullable
    public final String getCardId() {
        return this.cardId;
    }

    public final void setCardId(@Nullable String string) {
        this.cardId = string;
    }

    @Nullable
    public final String getCvc() {
        return this.cvc;
    }

    public final void setCvc(@Nullable String string) {
        this.cvc = string;
    }

    @Nullable
    public final String getRebillId() {
        return this.rebillId;
    }

    public final void setRebillId(@Nullable String string) {
        this.rebillId = string;
    }

    public AttachedCard(@Nullable String cardId, @Nullable String cvc) {
        this();
        this.cardId = cardId;
        this.cvc = cvc;
    }

    public AttachedCard(@Nullable String rebillId) {
        this();
        this.rebillId = rebillId;
    }

    @Override
    @NotNull
    public String encode(@NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.validate();
        String data = this.buildStringForEncoding$core();
        return CryptoUtils.INSTANCE.encodeBase64(CryptoUtils.INSTANCE.encryptRsa(data, publicKey));
    }

    @NotNull
    public final String buildStringForEncoding$core() {
        String rebillId = this.rebillId;
        CharSequence charSequence = rebillId;
        return charSequence == null || charSequence.length() == 0 ? "CardId=" + this.cardId + ";CVV=" + this.cvc : rebillId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate() {
        CharSequence charSequence = this.rebillId;
        if (charSequence == null || charSequence.length() == 0) {
            charSequence = this.cardId;
            if (!(!(charSequence == null || charSequence.length() == 0))) {
                boolean $i$a$-check-AttachedCard$validate$42 = false;
                String $i$a$-check-AttachedCard$validate$42 = "CardId should not be empty ";
                throw new IllegalStateException($i$a$-check-AttachedCard$validate$42.toString());
            }
            charSequence = this.cvc;
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string = this.cvc;
                Intrinsics.checkNotNull((Object)string);
                if (CardValidator.INSTANCE.validateSecurityCode(string)) {
                    return;
                }
            }
            boolean bl = false;
            if (bl) return;
            boolean $i$a$-check-AttachedCard$validate$52 = false;
            String $i$a$-check-AttachedCard$validate$52 = "Field security code should not be empty ";
            throw new IllegalStateException($i$a$-check-AttachedCard$validate$52.toString());
        }
        String string = this.rebillId;
        Intrinsics.checkNotNull((Object)string);
        if (((CharSequence)string).length() > 0) {
            return;
        }
        boolean bl = false;
        if (bl) return;
        boolean bl2 = false;
        String string2 = "RebillId should not be empty ";
        throw new IllegalStateException(string2.toString());
    }
}

